/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shade.relocation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.shade.relocation.Relocator;

public class SimpleRelocator
implements Relocator {
    private String pattern;
    private List excludes;

    public SimpleRelocator(String pattern, List excludes) {
        this.pattern = pattern.replace('.', '/');
        if (excludes != null) {
            this.excludes = new ArrayList();
            Iterator i = excludes.iterator();
            while (i.hasNext()) {
                String e = (String)i.next();
                this.excludes.add(e.replace('.', '/'));
            }
        }
    }

    public boolean canRelocate(String clazz) {
        if (this.excludes != null) {
            Iterator i = this.excludes.iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                if (exclude.endsWith("/*") && clazz.startsWith(exclude.substring(0, exclude.length() - 2))) {
                    return false;
                }
                if (!clazz.equals(exclude)) continue;
                return false;
            }
        }
        return clazz.startsWith(this.pattern);
    }

    public String relocate(String clazz) {
        return "hidden/" + clazz;
    }
}

