/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shade;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;
import org.codehaus.mojo.shade.Shader;
import org.codehaus.mojo.shade.relocation.Relocator;
import org.codehaus.mojo.shade.resource.ResourceTransformer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public class DefaultShader
extends AbstractLogEnabled
implements Shader {
    public void shade(Set jars, File uberJar, List relocators, List resourceTransformers) throws IOException {
        HashSet<String> resources = new HashSet<String>();
        MyRemapper remapper = new MyRemapper(relocators);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(uberJar));
        Iterator i = jars.iterator();
        while (i.hasNext()) {
            File jar = (File)i.next();
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> j = jarFile.entries();
            while (j.hasMoreElements()) {
                JarEntry entry = j.nextElement();
                String name = entry.getName();
                InputStream is = jarFile.getInputStream(entry);
                if (entry.isDirectory()) {
                    if (!resources.contains(name)) {
                        jos.putNextEntry(new JarEntry(name));
                        resources.add(name);
                    }
                } else if (name.endsWith(".class")) {
                    ClassReader cr = new ClassReader(is);
                    ClassWriter cw = new ClassWriter(cr, 0);
                    RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper);
                    cr.accept((ClassVisitor)cv, 0);
                    byte[] renamedClass = cw.toByteArray();
                    String newName = remapper.map(name.substring(0, name.indexOf(46)));
                    try {
                        jos.putNextEntry(new JarEntry(newName + ".class"));
                        IOUtil.copy((byte[])renamedClass, (OutputStream)jos);
                    }
                    catch (ZipException e) {
                        this.getLogger().warn("We have a duplicate " + newName + " in " + jar);
                    }
                } else {
                    boolean resourceTransformed = false;
                    Iterator k = resourceTransformers.iterator();
                    while (k.hasNext()) {
                        ResourceTransformer transformer = (ResourceTransformer)k.next();
                        if (!transformer.canTransformResource(name)) continue;
                        transformer.processResource(is);
                        resourceTransformed = true;
                        break;
                    }
                    if (!resourceTransformed) {
                        if (resources.contains(name)) continue;
                        jos.putNextEntry(new JarEntry(name));
                        IOUtil.copy((InputStream)is, (OutputStream)jos);
                        resources.add(name);
                    }
                }
                IOUtil.close((InputStream)is);
            }
        }
        i = resourceTransformers.iterator();
        while (i.hasNext()) {
            ResourceTransformer transformer = (ResourceTransformer)i.next();
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(jos);
        }
        IOUtil.close((OutputStream)jos);
    }

    class MyRemapper
    extends Remapper {
        List relocators;

        public MyRemapper(List relocators) {
            this.relocators = relocators;
        }

        public Object mapValue(Object object) {
            return object;
        }

        public String map(String name) {
            Iterator i = this.relocators.iterator();
            while (i.hasNext()) {
                Relocator r = (Relocator)i.next();
                if (!r.canRelocate(name)) continue;
                return r.relocate(name);
            }
            return name;
        }
    }
}

