/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen.introspection;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;
import org.apache.velocity.tools.generic.EscapeTool;
import org.codehaus.mojo.servicedocgen.Util;
import org.codehaus.mojo.servicedocgen.descriptor.JavaDocDescriptor;

public class JavaDocHelper {
    private static final String CODE_START = "<code>";
    private static final String CODE_END = "</code>";
    private static final Pattern PATTERN_JAVADOC_TAG = Pattern.compile("\\{@([a-zA-Z]+) ([^}]*)\\}");
    private static final String TAG_LINK = "link";
    private static final String TAG_LINKPLAIN = "linkplain";
    private static final String TAG_CODE = "code";
    private static final String TAG_LITERAL = "literal";
    private static final String TAG_VALUE = "value";
    private static final Set<String> JAVA_LANG_TYPES = new HashSet<String>(Arrays.asList("AbstractMethodError", "AbstractStringBuilder", "Appendable", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "AutoCloseable", "Boolean", "BootstrapMethodError", "Byte", "Character", "CharSequence", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "ClassValue", "Cloneable", "CloneNotSupportedException", "Comparable", "Compiler", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "FunctionalInterface", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LinkageError", "Long", "Math", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "Readable", "ReflectiveOperationException", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SafeVarargs", "SecurityException", "SecurityManager", "Short", "StackOverflowError", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringIndexOutOfBoundsException", "SuppressWarnings", "System", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void"));
    public static final String JAVADOC_JAVASE_URL = "http://docs.oracle.com/javase/8/docs/api/";
    public static final String JAVADOC_JAVAEE_URL = "https://docs.oracle.com/javaee/7/api/";
    private static final List<JavaDocDescriptor> JAVADOCS = Arrays.asList(new JavaDocDescriptor("java", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.accessibility", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.activation", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.activity", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.annotation.processing", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.crypto", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.imageio", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.jws", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.lang.model", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.management.j2ee", "https://docs.oracle.com/javaee/7/api/"), new JavaDocDescriptor("javax.management", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.naming", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.net", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.print", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.rmi", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.script", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.security.auth.message", "https://docs.oracle.com/javaee/7/api/"), new JavaDocDescriptor("javax.security.auth", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.security.cert", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.security.sasl", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.sound", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.sql", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.swing", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.tools", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.transaction", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.transaction.xa", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.bind", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.crypto", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.datatype", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.namespace", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.parsers", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.soap", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.stream", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.transform", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.validation", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.ws", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax.xml.xpath", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("javax", "https://docs.oracle.com/javaee/7/api/"), new JavaDocDescriptor("javafx", "https://docs.oracle.com/javafx/2/api/"), new JavaDocDescriptor("org.w3c.dom", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("org.xml.sax", "http://docs.oracle.com/javase/8/docs/api/"), new JavaDocDescriptor("org.springframework", "http://docs.spring.io/spring/docs/current/javadoc-api/"), new JavaDocDescriptor("org.apache.http", "https://hc.apache.org/httpcomponents-client-ga/httpclient/apidocs/"), new JavaDocDescriptor("com.google.common", "docs.guava-libraries.googlecode.com/git/javadoc/"));
    private static final CharFilter NO_SPACE_OR_HASH = new CharFilter(){

        public boolean accept(char c) {
            return c != '#' && c != ' ';
        }
    };
    private static final CharFilter NO_SPACE_OR_OPENING_BRACE = new CharFilter(){

        public boolean accept(char c) {
            return c != '(' && c != ' ';
        }
    };
    private static final CharFilter NO_COMMA_OR_CLOSING_BRACE = new CharFilter(){

        public boolean accept(char c) {
            return c != ',' && c != ')';
        }
    };
    private final List<JavaDocDescriptor> javaDocs;
    private final EscapeTool escapeTool;
    protected final JavaProjectBuilder builder;
    private final ClassLoader classloader;

    public JavaDocHelper(ClassLoader classloader, JavaProjectBuilder builder, List<JavaDocDescriptor> javaDocs) {
        this.classloader = classloader;
        this.builder = builder;
        this.javaDocs = new ArrayList<JavaDocDescriptor>();
        HashMap<String, JavaDocDescriptor> map = new HashMap<String, JavaDocDescriptor>();
        for (JavaDocDescriptor javaDocDescriptor : javaDocs) {
            String url = javaDocDescriptor.getUrl();
            if (!url.endsWith("/")) {
                javaDocDescriptor.setUrl(url + "/");
            }
            map.put(javaDocDescriptor.getPackagePrefix(), javaDocDescriptor);
        }
        for (JavaDocDescriptor javaDocDescriptor : JAVADOCS) {
            JavaDocDescriptor overridden = (JavaDocDescriptor)map.remove(javaDocDescriptor.getPackagePrefix());
            if (overridden == null) {
                this.javaDocs.add(javaDocDescriptor);
                continue;
            }
            this.javaDocs.add(overridden);
        }
        for (JavaDocDescriptor javaDocDescriptor : javaDocs) {
            if (!map.containsKey(javaDocDescriptor.getPackagePrefix())) continue;
            this.javaDocs.add(javaDocDescriptor);
        }
        this.escapeTool = new EscapeTool();
    }

    public String getQualifiedName(JavaSource source, String simpleName) {
        for (String importStatement : source.getImports()) {
            if (!simpleName.equals(Util.getSimpleName(importStatement))) continue;
            return importStatement;
        }
        String packageName = source.getPackageName();
        if (packageName.isEmpty()) {
            return simpleName;
        }
        if (JAVA_LANG_TYPES.contains(simpleName)) {
            return "java.lang." + simpleName;
        }
        return packageName + "." + simpleName;
    }

    public String parseJavaDoc(JavaClass sourceType, GenericType<?> byteType, String javadoc) {
        if (javadoc == null || javadoc.isEmpty()) {
            return "";
        }
        String comment = javadoc.trim().replace("\n", " ").replace("\r", "");
        Matcher matcher = PATTERN_JAVADOC_TAG.matcher(comment);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String tag = matcher.group(1);
            String text = matcher.group(2);
            String replacement = TAG_LINK.equals(tag) ? this.parseLink(sourceType, text, false) : (TAG_LINKPLAIN.equals(tag) ? this.parseLink(sourceType, text, true) : (TAG_CODE.equals(tag) ? CODE_START + text + CODE_END : (TAG_LITERAL.equals(tag) ? CODE_START + this.escapeTool.html((Object)text) + CODE_END : (TAG_VALUE.equals(tag) ? this.resolveValue(sourceType, byteType, text) : text))));
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String resolveValue(JavaClass sourceClass, GenericType<?> byteClass, String text) {
        int hashIndex = text.indexOf(35);
        if (hashIndex == 0) {
            String fieldName = text.substring(1);
            return this.getFieldValue(byteClass.getAssignmentClass(), fieldName);
        }
        if (hashIndex > 0) {
            String className = text.substring(0, hashIndex);
            String fieldName = text.substring(hashIndex + 1);
            if (!className.contains(".")) {
                className = this.getQualifiedName(sourceClass.getParentSource(), className);
            }
            try {
                Class<?> clazz = this.classloader.loadClass(className);
                return this.getFieldValue(clazz, fieldName);
            }
            catch (ClassNotFoundException e) {
                return fieldName;
            }
        }
        return text;
    }

    private String getFieldValue(Class<?> type, String fieldName) {
        Class<?> clazz = type;
        if (clazz.isEnum()) {
            Object value = Enum.valueOf(clazz, fieldName);
            return Util.toString(value, fieldName);
        }
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (Exception e) {
            while (clazz != null && field == null) {
                for (Field f : clazz.getDeclaredFields()) {
                    if (!f.getName().equals(fieldName)) continue;
                    field = f;
                    field.setAccessible(true);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (field == null) {
            return fieldName;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                Object value = field.get(null);
                return Util.toString(value, fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldName;
    }

    private String parseLink(JavaClass sourceClass, String text, boolean plain) {
        String javadocUrl;
        String qualifiedName;
        String simpleName;
        String title;
        JavaSource parentSource = sourceClass.getParentSource();
        String ref = text.trim();
        CharSequenceScanner scanner = new CharSequenceScanner(ref);
        String className = scanner.readWhile(NO_SPACE_OR_HASH);
        if (className.isEmpty()) {
            title = "";
            simpleName = sourceClass.getName();
            qualifiedName = sourceClass.getFullyQualifiedName();
        } else if (className.contains(".")) {
            qualifiedName = className;
            title = simpleName = Util.getSimpleName(className);
        } else {
            simpleName = className;
            qualifiedName = this.getQualifiedName(parentSource, simpleName);
            title = simpleName;
        }
        char separator = scanner.forceNext();
        String anchor = "";
        if (separator == '#') {
            StringBuilder titleBuffer = new StringBuilder(title);
            if (!title.isEmpty()) {
                titleBuffer.append('.');
            }
            String elementName = scanner.readWhile(NO_SPACE_OR_OPENING_BRACE);
            StringBuilder anchorBuffer = new StringBuilder("#");
            anchorBuffer.append(elementName);
            titleBuffer.append(elementName);
            char elementSeparator = scanner.forceNext();
            if (elementSeparator == '(') {
                titleBuffer.append('(');
                anchorBuffer.append('-');
                String comma = "";
                do {
                    titleBuffer.append(comma);
                    String argType = scanner.readWhile(NO_COMMA_OR_CLOSING_BRACE).trim();
                    elementSeparator = scanner.forceNext();
                    if (argType.isEmpty()) {
                        if (elementSeparator != ')') continue;
                        anchorBuffer.append('-');
                        break;
                    }
                    if (argType.contains(".")) {
                        anchorBuffer.append(argType);
                        titleBuffer.append(Util.getSimpleName(argType));
                    } else {
                        anchorBuffer.append(this.getQualifiedName(parentSource, argType));
                        titleBuffer.append(argType);
                    }
                    anchorBuffer.append('-');
                    comma = ", ";
                } while (elementSeparator == ',');
                titleBuffer.append(')');
            }
            title = titleBuffer.toString();
            anchor = anchorBuffer.toString();
        }
        scanner.skipWhile(' ');
        if (scanner.hasNext()) {
            title = scanner.read(Integer.MAX_VALUE);
        }
        StringBuilder buffer = new StringBuilder();
        if (!plain) {
            buffer.append(CODE_START);
        }
        if ((javadocUrl = this.findJavaDocUrl(qualifiedName)) == null) {
            buffer.append(title);
        } else {
            buffer.append("<a href='");
            buffer.append(javadocUrl);
            buffer.append(qualifiedName.replace('.', '/'));
            buffer.append(".html");
            buffer.append(anchor);
            buffer.append("'>");
            buffer.append(title);
            buffer.append("</a>");
        }
        if (!plain) {
            buffer.append(CODE_END);
        }
        return buffer.toString();
    }

    private String findJavaDocUrl(String qualifiedName) {
        for (JavaDocDescriptor javaDocDescriptor : this.javaDocs) {
            if (!qualifiedName.startsWith(javaDocDescriptor.getPackagePrefix())) continue;
            return javaDocDescriptor.getUrl();
        }
        return null;
    }
}

