/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen.descriptor;

import java.util.regex.Pattern;
import net.sf.mmm.util.pattern.base.RegexInfixPatternCompiler;
import org.codehaus.mojo.servicedocgen.descriptor.AbstractDescriptor;

public class ErrorDescriptor
extends AbstractDescriptor {
    public static final String DEFAULT_JSON_EXAMPLE = "{\"message\": \"text\",\n  \"code\": \"text\",\n  \"uuid\": \"text\",\n  \"errors\": {\n    \"bean.property.path\": [\n       \"Error message 1\",\n       \"Error message 2\"\n    ], \n    ...\n  }\n}";
    public static final String DEFAULT_XML_EXAMPLE = "<error code='text' uuid='text'>\n  <message>text</message>\n  <violations>\n    <violation path='bean.property.path'>\n      <message>Error message 1</message>\n      <message>Error message 2</message>\n    </violation>\n    ...\n  </violations>\n</error>";
    private String errorName;
    private Match match = Match.regex;
    private transient Pattern errorNamePattern;
    private transient Class<?> errorClass;
    private String jsonExample = "{\"message\": \"text\",\n  \"code\": \"text\",\n  \"uuid\": \"text\",\n  \"errors\": {\n    \"bean.property.path\": [\n       \"Error message 1\",\n       \"Error message 2\"\n    ], \n    ...\n  }\n}";
    private String xmlExample = "<error code='text' uuid='text'>\n  <message>text</message>\n  <violations>\n    <violation path='bean.property.path'>\n      <message>Error message 1</message>\n      <message>Error message 2</message>\n    </violation>\n    ...\n  </violations>\n</error>";
    private String statusCode = "500";
    private String comment = "";

    public String getErrorName() {
        if (this.errorName == null) {
            return "";
        }
        return this.errorName;
    }

    public void setErrorName(String errorNameRegex) {
        this.errorName = errorNameRegex;
    }

    public String getJsonExample() {
        return this.jsonExample;
    }

    public void setJsonExample(String jsonExample) {
        this.jsonExample = jsonExample;
    }

    public String getXmlExample() {
        return this.xmlExample;
    }

    public void setXmlExample(String xmlExample) {
        this.xmlExample = xmlExample;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Pattern getErrorNamePattern() {
        if (this.errorNamePattern == null && this.errorName != null) {
            this.errorNamePattern = this.errorName.isEmpty() ? Pattern.compile(".*") : RegexInfixPatternCompiler.INSTANCE.compile(this.errorName);
        }
        return this.errorNamePattern;
    }

    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public Class<?> getErrorClass() {
        return this.errorClass;
    }

    public void setErrorClass(Class<?> errorClass) {
        this.errorClass = errorClass;
    }

    public String toString() {
        return this.getErrorName() + "[" + (Object)((Object)this.match) + "]@" + this.statusCode;
    }

    public static enum Match {
        regex,
        assignable,
        always;

    }
}

