/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.servicedocgen.Analyzer;
import org.codehaus.mojo.servicedocgen.Util;
import org.codehaus.mojo.servicedocgen.descriptor.ServicesDescriptor;
import org.codehaus.mojo.servicedocgen.generation.velocity.VelocityServicesGenerator;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ServiceDocGenReport
extends AbstractMavenReport {
    @Parameter(defaultValue="servicedoc")
    private String reportFolder;
    @Parameter
    private String serviceClassName;
    @Parameter(defaultValue=".*Service.*")
    private String classnameRegex;
    private Pattern classnamePattern;
    @Parameter(required=false)
    private ServicesDescriptor descriptor;
    @Parameter(defaultValue="${project.runtimeClasspathElements}", readonly=true)
    private List<String> runtimeClasspathElements;
    @Parameter(defaultValue="org/codehaus/mojo/servicedocgen/generation/velocity")
    private String templatePath;
    @Parameter(defaultValue="Service-Documentation.html.vm")
    private String templateName;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter(defaultValue="false")
    private boolean introspectFields;
    private ClassLoader projectClassloader;

    public String getOutputName() {
        return "servicedoc/index";
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("servicedocgen-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.servicedocgen.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.servicedocgen.description");
    }

    public boolean isExternalReport() {
        return true;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.classnamePattern = Pattern.compile(this.classnameRegex);
        JavaProjectBuilder builder = new JavaProjectBuilder();
        if (!Util.isEmpty(this.sourceEncoding)) {
            builder.setEncoding(this.sourceEncoding);
        }
        try {
            boolean ok;
            List<JavaClass> serviceClasses = this.scanServices(builder);
            if (serviceClasses.isEmpty()) {
                this.getLog().info((CharSequence)"No services found - omitting service documentation generation.");
                return;
            }
            Analyzer analyzer = new Analyzer(this.getLog(), this.project, this.getProjectClassloader(), builder, this.descriptor, this.introspectFields);
            ServicesDescriptor services = analyzer.createServicesDescriptor(serviceClasses);
            this.getLog().info((CharSequence)"Generating output...");
            VelocityServicesGenerator generator = new VelocityServicesGenerator(Util.appendPath(this.templatePath, this.templateName));
            File reportDirectory = new File(this.outputDirectory, this.reportFolder);
            if (!reportDirectory.isDirectory() && !(ok = reportDirectory.mkdirs())) {
                throw new MojoExecutionException("Could not create directory " + reportDirectory);
            }
            generator.generate(services, reportDirectory);
        }
        catch (MavenReportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MavenReportException("Unexpected Error!", e);
        }
    }

    private List<JavaClass> scanServices(JavaProjectBuilder builder) throws IOException {
        JavaClass type;
        boolean isService;
        ArrayList<JavaClass> serviceClasses = new ArrayList<JavaClass>();
        for (String sourceDir : this.project.getCompileSourceRoots()) {
            File sourceFolder = new File(sourceDir);
            if (!sourceFolder.isDirectory()) continue;
            builder.addSourceFolder(sourceFolder);
            if (this.serviceClassName != null) continue;
            this.scanJavaFilesRecursive(sourceFolder, builder, serviceClasses);
        }
        if (this.serviceClassName != null && (isService = this.isServiceClass(type = builder.getClassByName(this.serviceClassName)))) {
            serviceClasses.add(type);
        }
        return serviceClasses;
    }

    private void scanJavaFilesRecursive(File sourceDir, JavaProjectBuilder builder, List<JavaClass> serviceClasses) throws IOException {
        File[] children = sourceDir.listFiles();
        if (children == null) {
            this.getLog().debug((CharSequence)("Directory does not exist: " + sourceDir));
            return;
        }
        for (File file : children) {
            if (file.isDirectory()) {
                this.scanJavaFilesRecursive(file, builder, serviceClasses);
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            try {
                JavaSource source = builder.addSource(file);
                for (JavaClass type : source.getClasses()) {
                    boolean isService = this.isServiceClass(type);
                    if (!isService) continue;
                    serviceClasses.add(type);
                }
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)("Error parsing file: " + file), (Throwable)e);
            }
        }
    }

    private boolean isServiceClass(JavaClass type) {
        if (this.classnamePattern.matcher(type.getName()).matches()) {
            this.getLog().debug((CharSequence)("Class matches: " + type.getName()));
            for (JavaAnnotation annotation : type.getAnnotations()) {
                if (!Path.class.getName().equals(annotation.getType().getFullyQualifiedName())) continue;
                this.getLog().info((CharSequence)("Found service: " + type.getName()));
                return true;
            }
        }
        return false;
    }

    private ClassLoader getProjectClassloader() throws MojoExecutionException {
        if (this.projectClassloader == null) {
            this.projectClassloader = new URLClassLoader(this.buildClasspathUrls(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        return this.projectClassloader;
    }

    private URL[] buildClasspathUrls() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>(this.runtimeClasspathElements.size());
        for (String element : this.runtimeClasspathElements) {
            try {
                URL url = new File(element).toURI().toURL();
                urls.add(url);
                this.getLog().debug((CharSequence)("Adding to classloader: " + url.toString()));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to access project dependency: " + element, (Exception)e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

