/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.lang.api.Datatype;
import net.sf.mmm.util.lang.api.SimpleDatatype;
import net.sf.mmm.util.math.api.NumberType;
import net.sf.mmm.util.math.base.MathUtilImpl;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilder;
import net.sf.mmm.util.pojo.descriptor.api.PojoDescriptorBuilderFactory;
import net.sf.mmm.util.pojo.descriptor.api.PojoPropertyDescriptor;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorMode;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArg;
import net.sf.mmm.util.pojo.descriptor.api.accessor.PojoPropertyAccessorNonArgMode;
import net.sf.mmm.util.pojo.descriptor.impl.PojoDescriptorBuilderFactoryImpl;
import net.sf.mmm.util.reflect.api.AnnotationUtil;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.AnnotationUtilImpl;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;
import net.sf.mmm.util.validation.base.Mandatory;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.servicedocgen.JavaScriptType;
import org.codehaus.mojo.servicedocgen.Util;
import org.codehaus.mojo.servicedocgen.descriptor.ContactDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.ErrorDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.InfoDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.LicenseDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.OperationDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.ParameterDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.ResponseDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.ServiceDescriptor;
import org.codehaus.mojo.servicedocgen.descriptor.ServicesDescriptor;
import org.codehaus.mojo.servicedocgen.introspection.JElement;
import org.codehaus.mojo.servicedocgen.introspection.JException;
import org.codehaus.mojo.servicedocgen.introspection.JMethod;
import org.codehaus.mojo.servicedocgen.introspection.JParameter;
import org.codehaus.mojo.servicedocgen.introspection.JReturn;
import org.codehaus.mojo.servicedocgen.introspection.JType;
import org.codehaus.mojo.servicedocgen.introspection.JavaDocHelper;

public class Analyzer {
    public static final String RESPONSE_REASON_SUCCESS = "Success";
    public static final String RESPONSE_REASON_ERROR = "Error";
    public static final String DESCRIPTION_VOID = "No content";
    private final ClassLoader projectClassloader;
    private final ReflectionUtil reflectionUtil;
    private final AnnotationUtil annotationUtil;
    private final PojoDescriptorBuilder pojoDescriptorBuilder;
    private final PojoDescriptorBuilderFactory pojoDescriptorBuilderFactory;
    private final JavaDocHelper javaDocHelper;
    private final JavaProjectBuilder builder;
    private final Log log;
    private final MavenProject project;
    private ServicesDescriptor descriptor;

    public Analyzer(Log log, MavenProject project, ClassLoader projectClassloader, JavaProjectBuilder builder, ServicesDescriptor descriptor, boolean introspectFields) {
        this.log = log;
        this.project = project;
        this.projectClassloader = projectClassloader;
        this.reflectionUtil = ReflectionUtilImpl.getInstance();
        this.annotationUtil = AnnotationUtilImpl.getInstance();
        this.builder = builder;
        this.descriptor = descriptor;
        this.pojoDescriptorBuilderFactory = PojoDescriptorBuilderFactoryImpl.getInstance();
        this.pojoDescriptorBuilder = introspectFields ? this.pojoDescriptorBuilderFactory.createPrivateFieldDescriptorBuilder() : this.pojoDescriptorBuilderFactory.createPublicMethodDescriptorBuilder();
        this.javaDocHelper = new JavaDocHelper(this.projectClassloader, this.builder, this.descriptor.getJavadocs());
        if (descriptor != null) {
            boolean hasFallback = false;
            for (ErrorDescriptor errorDescriptor : descriptor.getErrors()) {
                String errorName;
                if (errorDescriptor.getMatch() == ErrorDescriptor.Match.assignable) {
                    Class<Object> errorClass;
                    errorName = errorDescriptor.getErrorName();
                    try {
                        errorClass = projectClassloader.loadClass(errorName);
                    }
                    catch (Exception e) {
                        log.warn((CharSequence)("Failed to load error class '" + errorName + "':" + e.getMessage()), (Throwable)e);
                        errorClass = UnknownError.class;
                    }
                    errorDescriptor.setErrorClass(errorClass);
                    continue;
                }
                if (errorDescriptor.getMatch() != ErrorDescriptor.Match.regex || !(errorName = errorDescriptor.getErrorName()).isEmpty() && !errorName.equals(".") && !errorName.equals(".*")) continue;
                hasFallback = true;
            }
            if (!hasFallback) {
                ErrorDescriptor errorDescriptor = new ErrorDescriptor();
                errorDescriptor.setErrorName("");
                descriptor.getErrors().add(errorDescriptor);
            }
        }
    }

    protected Log getLog() {
        return this.log;
    }

    public ServicesDescriptor createServicesDescriptor(List<JavaClass> serviceClasses) throws Exception {
        InfoDescriptor info;
        if (this.descriptor == null) {
            this.descriptor = new ServicesDescriptor();
        }
        if ((info = this.descriptor.getInfo()) == null) {
            info = new InfoDescriptor();
            this.descriptor.setInfo(info);
        }
        this.createInfoDescriptor(info);
        Set<String> descriptorSchemes = this.descriptor.getSchemes();
        if (descriptorSchemes.isEmpty()) {
            descriptorSchemes.add("https");
        }
        for (JavaClass type : serviceClasses) {
            ServiceDescriptor service = this.createServiceDescriptor(type);
            this.descriptor.getServices().add(service);
        }
        return this.descriptor;
    }

    protected ServiceDescriptor createServiceDescriptor(JavaClass sourceType) throws Exception {
        Class<?> byteClass;
        this.getLog().info((CharSequence)("Analyzing " + sourceType.getName()));
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.setName(sourceType.getName());
        try {
            byteClass = this.projectClassloader.loadClass(sourceType.getFullyQualifiedName());
        }
        catch (ClassNotFoundException e) {
            throw new MavenReportException("Failed to load class " + sourceType.getName() + " - did you forget to invoke compile (e.g. mvn verify site)?", (Exception)e);
        }
        Path serviceBasePath = byteClass.getAnnotation(Path.class);
        if (serviceBasePath != null) {
            serviceDescriptor.setBasePath(serviceBasePath.value());
        }
        GenericType byteType = this.reflectionUtil.createGenericType(byteClass);
        serviceDescriptor.setJavaType(new JType(byteType, sourceType, this.reflectionUtil, this.javaDocHelper));
        serviceDescriptor.setDescription(this.javaDocHelper.parseJavaDoc(sourceType, byteType, sourceType.getComment()));
        Consumes consumes = (Consumes)this.annotationUtil.getTypeAnnotation(byteClass, Consumes.class);
        this.addConsumes(serviceDescriptor.getConsumes(), consumes);
        Produces produces = (Produces)this.annotationUtil.getTypeAnnotation(byteClass, Produces.class);
        this.addProduces(serviceDescriptor.getProduces(), produces);
        for (Method byteMethod : byteClass.getMethods()) {
            this.getLog().debug((CharSequence)("Analyzing method " + byteMethod.toString()));
            OperationDescriptor operationDescriptor = this.createOperationDescriptor(serviceDescriptor, byteMethod);
            if (operationDescriptor == null) continue;
            this.getLog().debug((CharSequence)"Method has been detected as service operation.");
            serviceDescriptor.getOperations().add(operationDescriptor);
        }
        Collections.sort(serviceDescriptor.getOperations());
        return serviceDescriptor;
    }

    protected InfoDescriptor createInfoDescriptor(InfoDescriptor info) {
        List licenses;
        LicenseDescriptor serviceLicense;
        ContactDescriptor contact;
        if (this.project == null) {
            return info;
        }
        if (info.getVersion() == null) {
            info.setVersion(this.project.getVersion());
        }
        if (info.getTitle() == null) {
            info.setTitle(this.project.getArtifactId());
        }
        if (info.getDescription() == null) {
            info.setDescription(this.project.getDescription());
        }
        if ((contact = info.getContact()) == null) {
            Organization organization = this.project.getOrganization();
            if (organization != null) {
                contact = new ContactDescriptor();
                contact.setUrl(organization.getUrl());
                contact.setName(organization.getName());
                info.setContact(contact);
            } else {
                String url = Util.getTrimmed(this.project.getUrl());
                if (!url.isEmpty()) {
                    contact = new ContactDescriptor();
                    contact.setUrl(url);
                    String name = Util.getTrimmed(this.project.getName());
                    if (name.isEmpty()) {
                        name = Util.getTrimmed(this.project.getArtifactId());
                    }
                    contact.setName(name);
                    info.setContact(contact);
                } else {
                    List developers = this.project.getDevelopers();
                    if (developers != null && !developers.isEmpty()) {
                        contact = new ContactDescriptor();
                        Developer developer = (Developer)developers.get(0);
                        contact.setUrl(Util.getTrimmed(developer.getUrl()));
                        contact.setEmail(Util.getTrimmed(developer.getEmail()));
                        contact.setName(Util.getTrimmed(developer.getName()));
                        info.setContact(contact);
                    }
                }
            }
        }
        if ((serviceLicense = info.getLicense()) == null && (licenses = this.project.getLicenses()) != null && !licenses.isEmpty()) {
            serviceLicense = new LicenseDescriptor();
            License projectLicense = (License)licenses.get(0);
            serviceLicense.setName(projectLicense.getName());
            serviceLicense.setUrl(projectLicense.getUrl());
            info.setLicense(serviceLicense);
        }
        return info;
    }

    private void addConsumes(Set<String> set, Consumes consumes) {
        if (consumes == null) {
            return;
        }
        for (String mimeType : consumes.value()) {
            set.add(mimeType);
        }
    }

    private void addProduces(Set<String> set, Produces produces) {
        if (produces == null) {
            return;
        }
        for (String mimeType : produces.value()) {
            set.add(mimeType);
        }
    }

    protected OperationDescriptor createOperationDescriptor(ServiceDescriptor serviceDescriptor, Method byteMethod) {
        Method annotatedParentMethod = byteMethod;
        Path methodPath = null;
        do {
            if ((methodPath = annotatedParentMethod.getAnnotation(Path.class)) != null || (annotatedParentMethod = this.reflectionUtil.getParentMethod(annotatedParentMethod)) != null) continue;
            return null;
        } while (methodPath == null);
        OperationDescriptor operationDescriptor = new OperationDescriptor();
        operationDescriptor.setPath(methodPath.value());
        if (this.annotationUtil.getMethodAnnotation(byteMethod, Deprecated.class) != null) {
            operationDescriptor.setDeprecated(true);
        }
        JMethod method = new JMethod(byteMethod, serviceDescriptor.getJavaType(), annotatedParentMethod);
        operationDescriptor.setJavaMethod(method);
        operationDescriptor.setDescription(method.getComment());
        Set<String> consumes = operationDescriptor.getConsumes();
        this.addConsumes(consumes, annotatedParentMethod.getAnnotation(Consumes.class));
        if (consumes.isEmpty()) {
            consumes.addAll(serviceDescriptor.getConsumes());
        }
        Set<String> produces = operationDescriptor.getProduces();
        this.addProduces(produces, annotatedParentMethod.getAnnotation(Produces.class));
        if (produces.isEmpty()) {
            produces.addAll(serviceDescriptor.getProduces());
        }
        operationDescriptor.setHttpMethod(this.createHttpMethodDescriptor(method));
        for (JParameter parameter : method.getParameters()) {
            ParameterDescriptor parameterDescriptor = this.createParameterDescriptor(serviceDescriptor, operationDescriptor, parameter);
            if (parameterDescriptor == null) continue;
            operationDescriptor.getParameters().add(parameterDescriptor);
        }
        ResponseDescriptor responseSuccess = this.createResponseDescriptor(serviceDescriptor, operationDescriptor, method.getReturns(), false);
        operationDescriptor.getResponses().add(responseSuccess);
        for (JException exception : method.getExceptions()) {
            ResponseDescriptor response = this.createResponseDescriptor(serviceDescriptor, operationDescriptor, exception, true);
            operationDescriptor.getResponses().add(response);
        }
        for (ErrorDescriptor errorDescriptor : this.descriptor.getErrors()) {
            if (errorDescriptor.getMatch() != ErrorDescriptor.Match.always) continue;
            JException exception = new JException(this.reflectionUtil.createGenericType(Throwable.class), null, errorDescriptor.getComment());
            ResponseDescriptor response = this.createResponseDescriptor(serviceDescriptor, operationDescriptor, exception, true);
            operationDescriptor.getResponses().add(response);
        }
        return operationDescriptor;
    }

    protected ParameterDescriptor createParameterDescriptor(ServiceDescriptor serviceDescriptor, OperationDescriptor operationDescriptor, JParameter parameter) {
        ParameterDescriptor parameterDescriptor = new ParameterDescriptor();
        parameterDescriptor.setJavaParameter(parameter);
        parameterDescriptor.setName(parameter.getName());
        parameterDescriptor.setDescription(parameter.getComment());
        String location = "body";
        boolean required = false;
        for (Annotation annotation : parameter.getByteAnnotations()) {
            if (annotation instanceof QueryParam) {
                QueryParam queryParam = (QueryParam)annotation;
                location = "query";
                parameterDescriptor.setName(queryParam.value());
                continue;
            }
            if (annotation instanceof HeaderParam) {
                HeaderParam headerParam = (HeaderParam)annotation;
                location = "header";
                parameterDescriptor.setName(headerParam.value());
                continue;
            }
            if (annotation instanceof PathParam) {
                PathParam pathParam = (PathParam)annotation;
                location = "path";
                parameterDescriptor.setName(pathParam.value());
                continue;
            }
            if (annotation instanceof FormParam) {
                FormParam formParam = (FormParam)annotation;
                location = "formData";
                parameterDescriptor.setName(formParam.value());
                continue;
            }
            if (annotation instanceof CookieParam) {
                CookieParam cookieParam = (CookieParam)annotation;
                location = "cookie";
                parameterDescriptor.setName(cookieParam.value());
                continue;
            }
            if (annotation instanceof Context) {
                if (UriInfo.class.isAssignableFrom(parameter.getByteType().getAssignmentClass())) {
                    location = "query/path";
                    continue;
                }
                return null;
            }
            if (annotation instanceof DefaultValue) {
                DefaultValue defaultValue = (DefaultValue)annotation;
                parameterDescriptor.setDefaultValue(defaultValue.value());
                continue;
            }
            if (annotation instanceof NotNull) {
                required = true;
                continue;
            }
            if (!(annotation instanceof Mandatory)) continue;
            required = true;
        }
        parameterDescriptor.setLocation(location);
        parameterDescriptor.setRequired(required);
        JavaScriptType javaScriptType = this.getJavaScriptType(parameter.getByteType(), false);
        parameterDescriptor.setJavaScriptType(javaScriptType.getName());
        parameterDescriptor.setExample(this.createExample(operationDescriptor, javaScriptType, parameter));
        return parameterDescriptor;
    }

    protected ResponseDescriptor createResponseDescriptor(ServiceDescriptor serviceDescriptor, OperationDescriptor operationDescriptor, JElement javaElement, boolean error) {
        String reason = error ? RESPONSE_REASON_ERROR : RESPONSE_REASON_SUCCESS;
        String example = null;
        ResponseDescriptor response = new ResponseDescriptor();
        GenericType<?> byteReturnType = javaElement.getByteType();
        String description = javaElement.getComment();
        if (error) {
            String statusCode = "500";
            for (ErrorDescriptor errorDescriptor : this.descriptor.getErrors()) {
                boolean matches = this.isMatchingError(byteReturnType, errorDescriptor);
                if (!matches) continue;
                statusCode = errorDescriptor.getStatusCode();
                boolean isXml = Util.containsSubstring(operationDescriptor.getProduces(), "xml");
                if (isXml) {
                    example = errorDescriptor.getXmlExample();
                    break;
                }
                example = errorDescriptor.getJsonExample();
                break;
            }
            response.setStatusCode(statusCode);
        } else if (byteReturnType.getRetrievalClass() == Void.TYPE) {
            response.setStatusCode("204");
            if (Util.isEmpty(description)) {
                description = DESCRIPTION_VOID;
            }
        } else {
            response.setStatusCode("200");
        }
        response.setDescription(description);
        response.setReason(reason);
        response.setJavaElement(javaElement);
        JavaScriptType javaScriptType = this.getJavaScriptType(byteReturnType, true);
        response.setJavaScriptType(javaScriptType.getName());
        if (example == null) {
            example = this.createExample(operationDescriptor, javaScriptType, javaElement);
        }
        response.setExample(example);
        return response;
    }

    private boolean isMatchingError(GenericType<?> byteReturnType, ErrorDescriptor errorDescriptor) {
        Class byteClass = byteReturnType.getRetrievalClass();
        ErrorDescriptor.Match match = errorDescriptor.getMatch();
        switch (match) {
            case regex: {
                Matcher matcher = errorDescriptor.getErrorNamePattern().matcher(byteClass.getName());
                return matcher.matches();
            }
            case assignable: {
                return errorDescriptor.getErrorClass().isAssignableFrom(byteClass);
            }
            case always: {
                return byteClass == Throwable.class;
            }
        }
        throw new IllegalCaseException(ErrorDescriptor.Match.class, (Enum)match);
    }

    private String createHttpMethodDescriptor(JMethod method) {
        Method byteMethod = method.getByteMethod();
        if (byteMethod.isAnnotationPresent(GET.class)) {
            return "get";
        }
        if (byteMethod.isAnnotationPresent(PUT.class)) {
            return "put";
        }
        if (byteMethod.isAnnotationPresent(POST.class)) {
            return "post";
        }
        if (byteMethod.isAnnotationPresent(DELETE.class)) {
            return "delete";
        }
        if (byteMethod.isAnnotationPresent(OPTIONS.class)) {
            return "options";
        }
        if (byteMethod.isAnnotationPresent(HEAD.class)) {
            return "head";
        }
        this.getLog().warn((CharSequence)("Service method " + method + " is missing JAX-RS annotation for HTTP method!"));
        return null;
    }

    protected JavaScriptType getJavaScriptType(GenericType<?> byteType, boolean retrieval) {
        return this.getJavaScriptType(byteType, retrieval, 0);
    }

    private JavaScriptType getJavaScriptType(GenericType<?> byteType, boolean retrieval, int recursion) {
        Class clazz = retrieval ? byteType.getRetrievalClass() : byteType.getAssignmentClass();
        Class byteClass = this.reflectionUtil.getNonPrimitiveType(clazz);
        if (Number.class.isAssignableFrom(byteClass)) {
            NumberType numberType = MathUtilImpl.getInstance().getNumberType(byteClass);
            if (numberType == null || numberType.isDecimal()) {
                return JavaScriptType.NUMBER;
            }
            return JavaScriptType.INTEGER;
        }
        if (byteClass.isArray() || Collection.class.isAssignableFrom(byteClass)) {
            return JavaScriptType.ARRAY;
        }
        if (Boolean.class.equals((Object)byteClass)) {
            return JavaScriptType.BOOLEAN;
        }
        if (Void.class.isAssignableFrom(byteClass)) {
            return JavaScriptType.VOID;
        }
        if (CharSequence.class.isAssignableFrom(byteClass)) {
            return JavaScriptType.STRING;
        }
        if (SimpleDatatype.class.isAssignableFrom(byteClass)) {
            if (recursion <= 2) {
                TypeVariable typeVariable = SimpleDatatype.class.getTypeParameters()[0];
                GenericType datatype = this.reflectionUtil.createGenericType(typeVariable, byteType);
                return this.getJavaScriptType(datatype, retrieval, recursion + 1);
            }
        } else {
            if (byteClass.isEnum()) {
                return JavaScriptType.STRING;
            }
            if (this.isDate(byteClass)) {
                return JavaScriptType.DATE;
            }
            if (Type.class.isAssignableFrom(byteClass)) {
                return JavaScriptType.TYPE;
            }
        }
        return JavaScriptType.OBJECT;
    }

    private boolean isDate(Class<?> byteClass) {
        if (Date.class.isAssignableFrom(byteClass)) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(byteClass)) {
            return true;
        }
        String className = byteClass.getName();
        if ("java.time.LocalDate".equals(className)) {
            return true;
        }
        if ("java.time.LocalDateTime".equals(className)) {
            return true;
        }
        if ("java.time.Instant".equals(className)) {
            return true;
        }
        if ("java.time.OffsetDateTime".equals(className)) {
            return true;
        }
        return "java.time.ZonedDateTime".equals(className);
    }

    protected String createExample(OperationDescriptor operationDescriptor, JavaScriptType javaScriptType, JElement element) {
        if (javaScriptType == JavaScriptType.VOID) {
            return null;
        }
        boolean retrieval = element instanceof JReturn;
        GenericType<?> byteType = element.getByteType();
        Class byteClass = retrieval ? byteType.getRetrievalClass() : byteType.getAssignmentClass();
        StringBuilder buffer = new StringBuilder();
        this.createExample(javaScriptType, byteType, byteClass, "", buffer, new HashSet(), retrieval);
        return buffer.toString();
    }

    private void createExample(GenericType<?> byteType, String indent, StringBuilder buffer, Set<Class<?>> visitedClassSet, boolean retrieval) {
        Class byteClass = retrieval ? byteType.getRetrievalClass() : byteType.getAssignmentClass();
        JavaScriptType javaScriptType = this.getJavaScriptType(byteType, retrieval);
        this.createExample(javaScriptType, byteType, byteClass, indent, buffer, visitedClassSet, retrieval);
    }

    private void createExample(JavaScriptType javaScriptType, GenericType<?> byteType, Class<?> byteClass, String indent, StringBuilder buffer, Set<Class<?>> visitedClassSet, boolean retrieval) {
        if (javaScriptType == JavaScriptType.ARRAY) {
            GenericType componentType = byteType.getComponentType();
            if (componentType != null) {
                buffer.append('[');
                this.createExample(componentType, indent, buffer, visitedClassSet, retrieval);
                buffer.append(']');
                return;
            }
        } else if (javaScriptType == JavaScriptType.OBJECT) {
            boolean added = true;
            if (!Datatype.class.isAssignableFrom(byteClass)) {
                added = visitedClassSet.add(byteClass);
            }
            if (byteClass == Object.class) {
                added = false;
            }
            if (added) {
                buffer.append('{');
                String childIndent = indent + "  ";
                buffer.append('\n');
                buffer.append(childIndent);
                if (Map.class.isAssignableFrom(byteClass)) {
                    this.createExampleForMap(byteType, buffer, visitedClassSet, retrieval, childIndent);
                } else {
                    this.createExampleForBean(byteType, byteClass, buffer, visitedClassSet, retrieval, childIndent);
                }
                buffer.append('\n');
                buffer.append(indent);
                buffer.append('}');
                return;
            }
        }
        buffer.append(javaScriptType.getExample());
    }

    private void createExampleForBean(GenericType<?> byteType, Class<?> byteClass, StringBuilder buffer, Set<Class<?>> visitedClassSet, boolean retrieval, String childIndent) {
        PojoDescriptor pojoDescriptor = this.pojoDescriptorBuilder.getDescriptor(byteType);
        boolean repeating = false;
        ArrayList propertyDescriptors = new ArrayList(pojoDescriptor.getPropertyDescriptors());
        Comparator<PojoPropertyDescriptor> comparator = new Comparator<PojoPropertyDescriptor>(){

            @Override
            public int compare(PojoPropertyDescriptor o1, PojoPropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(propertyDescriptors, comparator);
        for (PojoPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            PojoPropertyAccessorNonArg getter;
            if (propertyDescriptor.getName().equals("class") || (getter = (PojoPropertyAccessorNonArg)propertyDescriptor.getAccessor((PojoPropertyAccessorMode)PojoPropertyAccessorNonArgMode.GET)) == null) continue;
            if (repeating) {
                buffer.append(",\n");
                buffer.append(childIndent);
            }
            repeating = true;
            String propertyName = propertyDescriptor.getName();
            buffer.append('\"');
            buffer.append(propertyName);
            buffer.append("\" = ");
            this.createExample(getter.getPropertyType(), childIndent, buffer, visitedClassSet, retrieval);
        }
    }

    private void createExampleForMap(GenericType<?> byteType, StringBuilder buffer, Set<Class<?>> visitedClassSet, boolean retrieval, String childIndent) {
        buffer.append("\"&lt;key&gt;\" = ");
        GenericType componentType = byteType.getComponentType();
        if (componentType == null) {
            buffer.append("...");
        } else {
            this.createExample(componentType, childIndent, buffer, visitedClassSet, retrieval);
            buffer.append('\n');
            buffer.append(childIndent);
            buffer.append(", ...");
        }
    }
}

