/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.mojo.rpm.BaseTrigger;
import org.codehaus.mojo.rpm.FileHelper;
import org.codehaus.mojo.rpm.FilteringDirectoryArchiver;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Passphrase;
import org.codehaus.mojo.rpm.RPMHelper;
import org.codehaus.mojo.rpm.Scriptlet;
import org.codehaus.mojo.rpm.SoftlinkSource;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.mojo.rpm.SpecWriter;
import org.codehaus.mojo.rpm.UnixPrintWriter;
import org.codehaus.mojo.rpm.VersionHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

abstract class AbstractRPMMojo
extends AbstractMojo
implements VersionHelper.RPMVersionableMojo {
    @Parameter(required=true, property="rpm.name", defaultValue="${project.artifactId}")
    private String name;
    @Parameter(required=true, alias="version", property="rpm.version", defaultValue="${project.version}")
    private String projversion;
    @Parameter(property="rpm.release")
    private String release;
    @Parameter
    private String needarch;
    private String targetArch;
    @Parameter
    private String targetOS;
    @Parameter
    private String targetVendor;
    @Parameter(property="gpg.keyname")
    private String keyname;
    @Parameter(property="gpg.homedir")
    private File keypath;
    @Parameter
    private Passphrase keyPassphrase;
    @Parameter(property="gpg.passphraseServerId", defaultValue="gpg.passphrase")
    private String passphraseServerId;
    @Parameter(property="rpm.description", defaultValue="${project.description}")
    private String description;
    @Parameter(property="rpm.summary", defaultValue="${project.name}")
    private String summary;
    @Parameter
    private String license;
    @Parameter
    private String distribution;
    @Parameter
    private String epoch;
    @Parameter
    private File icon;
    @Parameter(property="rpm.vendor", defaultValue="${project.organization.name}")
    private String vendor;
    @Parameter(property="rpm.url", defaultValue="${project.organization.url}")
    private String url;
    @Parameter(required=true)
    private String group;
    @Parameter(property="rpm.packager", defaultValue="${project.organization.name}")
    private String packager;
    @Parameter(defaultValue="true")
    private boolean autoProvides;
    @Parameter(defaultValue="true")
    private boolean autoRequires;
    @Parameter
    private LinkedHashSet<String> provides;
    @Parameter
    private LinkedHashSet<String> requires;
    @Parameter
    private LinkedHashSet<String> prereqs;
    @Parameter
    private LinkedHashSet<String> obsoletes;
    @Parameter
    private LinkedHashSet<String> conflicts;
    @Parameter
    private String prefix;
    @Parameter
    private List<String> prefixes;
    @Parameter(defaultValue="${project.build.directory}/rpm")
    private File workarea;
    @Parameter
    private List<Mapping> mappings = Collections.emptyList();
    @Parameter
    private Scriptlet prepareScriptlet;
    @Parameter
    private Scriptlet preinstallScriptlet;
    @Parameter
    private Scriptlet postinstallScriptlet;
    @Parameter
    private Scriptlet installScriptlet;
    @Parameter
    private Scriptlet preremoveScriptlet;
    @Parameter
    private Scriptlet postremoveScriptlet;
    @Parameter
    private Scriptlet verifyScriptlet;
    @Parameter
    private Scriptlet cleanScriptlet;
    @Parameter
    private Scriptlet pretransScriptlet;
    @Parameter
    private Scriptlet posttransScriptlet;
    @Parameter
    private List<BaseTrigger> triggers;
    @Parameter
    private List<String> filters;
    @Parameter(property="maven.rpm.escapeString")
    private String escapeString;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(required=true, readonly=true, property="project.build.sourceEncoding")
    private String sourceEncoding;
    @Parameter(required=true, readonly=true, property="project.artifact")
    private Artifact artifact;
    @Parameter(required=true, readonly=true, property="project.attachedArtifacts")
    private List<Artifact> attachedArtifacts;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private boolean repackJars = false;
    @Parameter
    private List<String> defineStatements;
    @Parameter
    private String defaultFilemode;
    @Parameter
    private String defaultDirmode;
    @Parameter
    private String defaultUsername;
    @Parameter
    private String defaultGroupname;
    @Parameter
    private boolean disabled;
    @Parameter(required=true, defaultValue="rpm.version")
    private String versionProperty;
    @Parameter(required=true, defaultValue="rpm.release")
    private String releaseProperty;
    @Parameter
    private File changelogFile;
    @Parameter(property="rpm.copyTo")
    private File copyTo;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    private final Map<String, String> macroKeyToValue = new HashMap<String, String>();
    private final Map<String, List<SoftlinkSource>> linkTargetToSources = new LinkedHashMap<String, List<SoftlinkSource>>();
    private File buildroot;
    private File rpmBuildroot;
    private String changelog;
    private RPMHelper helper;
    private List<FileUtils.FilterWrapper> defaultFilterWrappers;

    AbstractRPMMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.disabled) {
            this.getLog().info((CharSequence)"MOJO is disabled. Doing nothing.");
            if ("rpm".equals(this.project.getPackaging())) {
                this.project.setPackaging("pom");
            }
            return;
        }
        if (this.prefix != null) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<String>();
            }
            this.prefixes.add(this.prefix);
        }
        this.helper = new RPMHelper(this);
        this.checkParams(this.helper);
        String classifier = this.getClassifier();
        this.workarea = classifier != null ? new File(this.workarea, this.name + '-' + classifier) : new File(this.workarea, this.name);
        this.buildWorkArea();
        this.setDefaultWrappers();
        FilteringDirectoryArchiver copier = new FilteringDirectoryArchiver();
        copier.setMavenFileFilter(this.mavenFileFilter);
        new FileHelper(this, copier).installFiles();
        this.writeSpecFile();
        this.loadGpgPassphrase();
        this.helper.buildPackage();
        this.afterExecution();
        if (this.copyTo != null) {
            this.makeSecondCopy();
        }
    }

    private void makeSecondCopy() throws MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Copy " + this.getRPMFile() + " to " + this.copyTo));
            FileUtils.copyFile((File)this.getRPMFile(), (File)this.copyTo);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to copy file");
        }
    }

    protected void afterExecution() throws MojoExecutionException, MojoFailureException {
    }

    String getClassifier() {
        return null;
    }

    protected File getRPMFile() {
        File rpms = new File(this.workarea, "RPMS");
        File archDir = new File(rpms, this.targetArch);
        return new File(archDir, this.name + '-' + this.projversion + '-' + this.release + '.' + this.targetArch + ".rpm");
    }

    private void setDefaultWrappers() throws MojoExecutionException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
        mavenResourcesExecution.setEscapeString(this.escapeString);
        try {
            this.defaultFilterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, false, this.session, mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            this.getLog().error((CharSequence)("fail to build filering wrappers " + e.getMessage()));
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void buildWorkArea() throws MojoFailureException, MojoExecutionException {
        String[] topdirs = new String[]{"BUILD", "RPMS", "SOURCES", "SPECS", "SRPMS", "tmp-buildroot", "buildroot"};
        if (!this.workarea.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.workarea.getAbsolutePath()));
            if (!this.workarea.mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + this.workarea.getAbsolutePath());
            }
        }
        this.validateWorkarea();
        for (String topdir : topdirs) {
            File dir = new File(this.workarea, topdir);
            if (dir.exists()) {
                this.getLog().info((CharSequence)("Directory " + dir.getAbsolutePath() + " already exists. Deleting all contents."));
                try {
                    FileUtils.cleanDirectory((File)dir);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to clear directory: " + dir.getName(), (Exception)e);
                }
            }
            this.getLog().info((CharSequence)("Creating directory " + dir.getAbsolutePath()));
            if (dir.mkdir()) continue;
            throw new MojoFailureException("Unable to create directory " + dir.getAbsolutePath());
        }
        this.buildroot = new File(this.workarea, "tmp-buildroot");
        this.rpmBuildroot = new File(this.workarea, "buildroot");
    }

    private void checkParams(RPMHelper helper) throws MojoExecutionException, MojoFailureException {
        String release;
        String projversion;
        Log log = this.getLog();
        if (this.versionProperty != null && (projversion = this.project.getProperties().getProperty(this.versionProperty)) != null) {
            this.projversion = projversion;
        }
        if (this.releaseProperty != null && (release = this.project.getProperties().getProperty(this.releaseProperty)) != null) {
            this.release = release;
        }
        if (this.projversion == null || this.release == null || this.projversion.contains("-")) {
            VersionHelper.Version version = new VersionHelper(this).calculateVersion();
            this.projversion = version.version;
            this.release = version.release;
        }
        log.debug((CharSequence)("project version = " + this.projversion));
        log.debug((CharSequence)("project release = " + this.release));
        this.targetArch = this.needarch == null || this.needarch.length() == 0 || "false".equalsIgnoreCase(this.needarch) ? "noarch" : ("true".equalsIgnoreCase(this.needarch) ? helper.getArch() : this.needarch);
        log.debug((CharSequence)("targetArch = " + this.targetArch));
        if (this.targetOS == null || this.targetOS.length() == 0) {
            this.targetOS = Os.OS_NAME;
        }
        log.debug((CharSequence)("targetOS = " + this.targetOS));
        if (this.targetVendor == null || this.targetVendor.length() == 0) {
            this.targetVendor = helper.getHostVendor();
        }
        log.debug((CharSequence)("targetVendor = " + this.targetVendor));
        for (Mapping map : this.mappings) {
            if (map.getDirectory() == null) {
                throw new MojoFailureException("<mapping> element must contain the destination directory");
            }
            if (map.getSources() == null) continue;
            for (Source src : map.getSources()) {
                if (src.getLocation() != null) continue;
                throw new MojoFailureException("<mapping><source> tag must contain the source directory");
            }
        }
        if (this.changelog == null && this.changelogFile != null) {
            if (!this.changelogFile.exists()) {
                log.debug((CharSequence)(this.changelogFile.getAbsolutePath() + " does not exist - ignoring"));
            } else {
                try {
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new FileReader(this.changelogFile));
                    while (br.ready()) {
                        String line = br.readLine();
                        sb.append(line);
                        sb.append('\n');
                    }
                    br.close();
                    this.changelog = sb.toString();
                }
                catch (Throwable t) {
                    throw new MojoExecutionException("Unable to read " + this.changelogFile.getAbsolutePath(), t);
                }
            }
        }
        if (this.license == null) {
            this.license = this.generateDefaultCopyrightText();
        }
        if (this.obsoletes != null && "true".equals(System.getProperty("disable.mrpm24"))) {
            if (this.provides == null) {
                this.provides = this.obsoletes;
            } else {
                this.provides.addAll(this.obsoletes);
            }
        }
        if (!this.repackJars) {
            if (this.defineStatements == null) {
                this.defineStatements = new ArrayList<String>();
            }
            this.defineStatements.add("__jar_repack 0");
        }
        this.processDefineStatements();
    }

    private void processDefineStatements() {
        if (this.defineStatements == null) {
            return;
        }
        for (String define : this.defineStatements) {
            String[] parts = define.split(" ");
            if (parts.length != 2) continue;
            this.macroKeyToValue.put(parts[0], parts[1]);
        }
    }

    private void validateWorkarea() throws MojoExecutionException {
        if (!this.workarea.isDirectory()) {
            throw new MojoExecutionException(this.workarea + " is not a directory");
        }
        if (this.workarea.getAbsolutePath().trim().indexOf(" ") != -1) {
            throw new MojoExecutionException(this.workarea + " contains a space in path");
        }
    }

    String evaluateMacro(String macro) throws MojoExecutionException {
        if (this.macroKeyToValue.containsKey(macro)) {
            return this.macroKeyToValue.get(macro);
        }
        String value = this.helper.evaluateMacro(macro);
        this.macroKeyToValue.put(macro, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSpecFile() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        File specf = new File(f, this.name + ".spec");
        try {
            this.getLog().info((CharSequence)("Creating spec file " + specf.getAbsolutePath()));
            UnixPrintWriter spec = new UnixPrintWriter(new FileWriter(specf));
            try {
                new SpecWriter(this, spec).writeSpecFile();
            }
            finally {
                spec.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + specf.getAbsolutePath(), (Exception)e);
        }
    }

    private String generateDefaultCopyrightText() {
        String organization;
        String year = this.project.getInceptionYear();
        String string = organization = this.project.getOrganization() == null ? null : this.project.getOrganization().getName();
        String copyrightText = year != null && organization != null ? year + " " + organization : (year == null ? organization : year);
        return "(c) " + copyrightText;
    }

    final Map<String, List<SoftlinkSource>> getLinkTargetToSources() {
        return this.linkTargetToSources;
    }

    final String getName() {
        return this.name;
    }

    @Override
    public final String getRelease() {
        return this.release;
    }

    @Override
    public Date getBuildTimestamp() {
        return this.session == null ? new Date() : this.session.getStartTime();
    }

    final String getDescription() {
        return this.description;
    }

    final String getSummary() {
        return this.summary;
    }

    final String getLicense() {
        return this.license;
    }

    final String getEpoch() {
        return this.epoch;
    }

    final String getDistribution() {
        return this.distribution;
    }

    final File getIcon() {
        return this.icon;
    }

    final String getVendor() {
        return this.vendor;
    }

    final String getUrl() {
        return this.url;
    }

    final String getGroup() {
        return this.group;
    }

    final String getPackager() {
        return this.packager;
    }

    final boolean isAutoProvides() {
        return this.autoProvides;
    }

    final boolean isAutoRequires() {
        return this.autoRequires;
    }

    final LinkedHashSet<String> getProvides() {
        return this.provides;
    }

    final LinkedHashSet<String> getRequires() {
        return this.requires;
    }

    final LinkedHashSet<String> getPrereqs() {
        return this.prereqs;
    }

    final LinkedHashSet<String> getObsoletes() {
        return this.obsoletes;
    }

    final LinkedHashSet<String> getConflicts() {
        return this.conflicts;
    }

    final List<String> getPrefixes() {
        return this.prefixes;
    }

    final List<Mapping> getMappings() {
        return this.mappings;
    }

    final Scriptlet getPrepareScriptlet() {
        return this.prepareScriptlet;
    }

    final Scriptlet getPreinstallScriptlet() {
        return this.preinstallScriptlet;
    }

    final Scriptlet getPostinstallScriptlet() {
        return this.postinstallScriptlet;
    }

    final Scriptlet getInstallScriptlet() {
        return this.installScriptlet;
    }

    final Scriptlet getPreremoveScriptlet() {
        return this.preremoveScriptlet;
    }

    final Scriptlet getPostremoveScriptlet() {
        return this.postremoveScriptlet;
    }

    final Scriptlet getVerifyScriptlet() {
        return this.verifyScriptlet;
    }

    final Scriptlet getCleanScriptlet() {
        return this.cleanScriptlet;
    }

    final Scriptlet getPretransScriptlet() {
        return this.pretransScriptlet;
    }

    final Scriptlet getPosttransScriptlet() {
        return this.posttransScriptlet;
    }

    final List<BaseTrigger> getTriggers() {
        return this.triggers;
    }

    final List<String> getDefineStatements() {
        return this.defineStatements;
    }

    final String getDefaultFilemode() {
        return this.defaultFilemode;
    }

    final String getDefaultDirmode() {
        return this.defaultDirmode;
    }

    final String getDefaultUsername() {
        return this.defaultUsername;
    }

    final String getDefaultGroupname() {
        return this.defaultGroupname;
    }

    final File getBuildroot() {
        return this.buildroot;
    }

    final File getRPMBuildroot() {
        return this.rpmBuildroot;
    }

    @Override
    public final String getVersion() {
        return this.projversion;
    }

    final String getChangelog() {
        return this.changelog;
    }

    final String getTargetArch() {
        return this.targetArch;
    }

    final String getTargetOS() {
        return this.targetOS;
    }

    final String getTargetVendor() {
        return this.targetVendor;
    }

    final File getKeypath() {
        return this.keypath;
    }

    final String getKeyname() {
        return this.keyname;
    }

    final Passphrase getKeyPassphrase() {
        return this.keyPassphrase;
    }

    final File getWorkarea() {
        return this.workarea;
    }

    final Artifact getArtifact() {
        return this.artifact;
    }

    final List<Artifact> getAttachedArtifacts() {
        return this.attachedArtifacts;
    }

    final List<FileUtils.FilterWrapper> getFilterWrappers() {
        return this.defaultFilterWrappers;
    }

    private void loadGpgPassphrase() throws MojoFailureException {
        Server server;
        if (this.keyPassphrase == null && this.passphraseServerId != null && (server = this.settings.getServer(this.passphraseServerId)) != null && server.getPassphrase() != null) {
            try {
                this.keyPassphrase = new Passphrase();
                this.keyPassphrase.setPassphrase(this.securityDispatcher.decrypt(server.getPassphrase()));
            }
            catch (SecDispatcherException e) {
                throw new MojoFailureException("Unable to decrypt gpg password", (Throwable)e);
            }
        }
    }
}

