/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;

public class Scriptlet {
    private String subpackage;
    private String program;
    private String script;
    private File scriptFile;
    private String fileEncoding;
    private String sourceEncoding;

    public String getSubpackage() {
        return this.subpackage;
    }

    public void setSubpackage(String subpackage) {
        this.subpackage = subpackage;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getFileEncoding() {
        if (this.fileEncoding != null && !"".equals(this.fileEncoding)) {
            return this.fileEncoding;
        }
        return this.sourceEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    protected final void write(PrintWriter writer, String directive) throws IOException {
        if (this.scriptFile != null && !this.scriptFile.exists()) {
            throw new RuntimeException("Invalid scriptlet declaration found - defined scriptFile does not exist: " + this.scriptFile.getPath());
        }
        if (this.script != null || this.scriptFile != null && this.scriptFile.exists() || this.program != null) {
            writer.println();
            writer.println(this.buildScriptletLine(directive));
            this.writeContent(writer);
        }
    }

    protected String buildScriptletLine(String directive) {
        StringBuilder builder = new StringBuilder();
        builder.append(directive);
        if (this.subpackage != null) {
            builder.append(" -n ");
            builder.append(this.subpackage);
        }
        if (this.program != null) {
            builder.append(" -p ");
            builder.append(this.program);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeContent(PrintWriter writer) throws IOException {
        if (this.script != null) {
            writer.println(this.script);
        } else if (this.scriptFile.exists()) {
            InputStreamReader reader = this.fileEncoding != null ? new InputStreamReader((InputStream)new FileInputStream(this.scriptFile), this.fileEncoding) : new FileReader(this.scriptFile);
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(reader);
                while ((line = bufferedReader.readLine()) != null) {
                    writer.println(line);
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append("Scriptlet[");
        buffer.append("subpackage=");
        buffer.append(this.subpackage);
        buffer.append(",program=");
        buffer.append(this.program);
        buffer.append(",script=");
        buffer.append(this.script);
        buffer.append(",scriptFile=");
        buffer.append(this.scriptFile);
        buffer.append(",fileEncoding=");
        buffer.append(this.fileEncoding);
        buffer.append("]");
        return buffer.toString();
    }
}

