/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.text.MessageFormat;
import java.util.Date;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.VersionHelper;

@Mojo(name="version", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class VersionMojo
extends AbstractMojo
implements VersionHelper.RPMVersionableMojo {
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    @Component
    private MavenSession session;
    @Parameter(required=true, alias="version", property="project.version")
    private String projversion;
    @Parameter(required=true, defaultValue="rpm.version")
    private String versionProperty;
    @Parameter
    private String release;
    @Parameter(required=true, defaultValue="rpm.release")
    private String releaseProperty;

    public void execute() throws MojoExecutionException, MojoFailureException {
        VersionHelper.Version version = new VersionHelper(this).calculateVersion();
        this.setProperty(this.versionProperty, version.version);
        this.setProperty(this.releaseProperty, version.release);
    }

    private void setProperty(String key, String value) {
        this.getLog().info((CharSequence)MessageFormat.format("setting [{0}] property to value [{1}].", key, value));
        this.project.getProperties().put(key, value);
    }

    @Override
    public final String getVersion() {
        return this.projversion;
    }

    @Override
    public final String getRelease() {
        return this.release;
    }

    @Override
    public Date getBuildTimestamp() {
        return this.session.getStartTime();
    }
}

