/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rpm.AbstractRPMMojo;
import org.codehaus.mojo.rpm.LogStreamConsumer;
import org.codehaus.mojo.rpm.Passphrase;
import org.codehaus.mojo.rpm.RPMSigner;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

final class RPMHelper {
    private final AbstractRPMMojo mojo;

    public RPMHelper(AbstractRPMMojo mojo) {
        this.mojo = mojo;
    }

    public String getHostVendor() throws MojoExecutionException {
        Log log = this.mojo.getLog();
        Commandline cl = new Commandline();
        cl.setExecutable("rpm");
        cl.addArguments(new String[]{"-E", "%{_host_vendor}"});
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        LogStreamConsumer stderr = new LogStreamConsumer(2, log);
        try {
            int result;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("RPM query for default vendor returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to query for default vendor from RPM", (Exception)((Object)e));
        }
        return stdout.getOutput().trim();
    }

    public void buildPackage() throws MojoExecutionException {
        File workarea = this.mojo.getWorkarea();
        File f = new File(workarea, "SPECS");
        Commandline cl = new Commandline();
        cl.setExecutable("rpmbuild");
        cl.setWorkingDirectory(f.getAbsolutePath());
        cl.createArg().setValue("-bb");
        cl.createArg().setValue("--target");
        cl.createArg().setValue(this.mojo.getTargetArch() + '-' + this.mojo.getTargetVendor() + '-' + this.mojo.getTargetOS());
        cl.createArg().setValue("--buildroot");
        cl.createArg().setValue(this.mojo.getRPMBuildroot().getAbsolutePath());
        cl.createArg().setValue("--define");
        cl.createArg().setValue("_topdir " + workarea.getAbsolutePath());
        String keyname = this.mojo.getKeyname();
        Passphrase keyPassphrase = this.mojo.getKeyPassphrase();
        if (keyname != null && keyPassphrase == null) {
            cl.createArg().setValue("--define");
            cl.createArg().setValue("_gpg_name " + keyname);
            cl.createArg().setValue("--sign");
        }
        cl.createArg().setValue(this.mojo.getName() + ".spec");
        Log log = this.mojo.getLog();
        LogStreamConsumer stdout = new LogStreamConsumer(1, log);
        LogStreamConsumer stderr = new LogStreamConsumer(2, log);
        try {
            int result;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("RPM build execution returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to build the RPM", (Exception)((Object)e));
        }
        if (keyname != null && keyPassphrase != null) {
            RPMSigner signer = new RPMSigner(keyname, keyPassphrase.getPassphrase(), log);
            try {
                signer.sign(this.mojo.getRPMFile());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to sign RPM", e);
            }
        }
    }

    public String evaluateMacro(String macro) throws MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("rpm");
        cl.createArg().setValue("--eval");
        cl.createArg().setValue('%' + macro);
        Log log = this.mojo.getLog();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        LogStreamConsumer stderr = new LogStreamConsumer(2, log);
        try {
            int result;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("rpm --eval returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to evaluate macro: " + macro, (Exception)((Object)e));
        }
        return stdout.getOutput().trim();
    }

    public String getArch() throws MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("rpm");
        cl.addArguments(new String[]{"-E", "%{_arch}"});
        CommandLineUtils.StringStreamConsumer stdConsumer = new CommandLineUtils.StringStreamConsumer();
        LogStreamConsumer errConsumer = new LogStreamConsumer(2, this.mojo.getLog());
        try {
            int result;
            if (this.mojo.getLog().isDebugEnabled()) {
                this.mojo.getLog().debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdConsumer, (StreamConsumer)errConsumer)) != 0) {
                throw new MojoExecutionException("rpm -E %{_arch} returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable get system architecture", (Exception)((Object)e));
        }
        return stdConsumer.getOutput().trim();
    }
}

