/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.BaseTrigger;
import org.codehaus.mojo.rpm.Dependency;
import org.codehaus.mojo.rpm.LogStreamConsumer;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Passphrase;
import org.codehaus.mojo.rpm.RPMSigner;
import org.codehaus.mojo.rpm.Scriptlet;
import org.codehaus.mojo.rpm.SoftlinkSource;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.plexus.archiver.dir.DirectoryArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractRPMMojo
extends AbstractMojo {
    private static final String DESTINATION_DIRECTORY_ERROR_MSG = "Source has a destination [{0}], but the location [{1}] does not refer to a file.";
    private final Map linkTargetToSources = new LinkedHashMap();
    private String name;
    private String projversion;
    private String release;
    private String needarch;
    private String targetArch;
    private String targetOS;
    private String targetVendor;
    private String keyname;
    private Passphrase keyPassphrase;
    private String description;
    private String summary;
    private String copyright;
    private String distribution;
    private File icon;
    private String vendor;
    private String url;
    private String group;
    private String packager;
    private boolean autoProvides;
    private boolean autoRequires;
    private LinkedHashSet provides;
    private LinkedHashSet requires;
    private LinkedHashSet prereqs;
    private LinkedHashSet obsoletes;
    private LinkedHashSet conflicts;
    private String prefix;
    private File workarea;
    private List mappings;
    private String prepare;
    private File prepareScript;
    private Scriptlet prepareScriptlet;
    private String preinstall;
    private File preinstallScript;
    private Scriptlet preinstallScriptlet;
    private String postinstall;
    private File postinstallScript;
    private Scriptlet postinstallScriptlet;
    private String install;
    private File installScript;
    private Scriptlet installScriptlet;
    private String preremove;
    private File preremoveScript;
    private Scriptlet preremoveScriptlet;
    private String postremove;
    private File postremoveScript;
    private Scriptlet postremoveScriptlet;
    private String verify;
    private File verifyScript;
    private Scriptlet verifyScriptlet;
    private String clean;
    private File cleanScript;
    private Scriptlet cleanScriptlet;
    private Scriptlet pretransScriptlet;
    private Scriptlet posttransScriptlet;
    private List triggers;
    private DirectoryArchiver copier;
    private Artifact artifact;
    private List attachedArtifacts;
    MavenProject project;
    private List defineStatements;
    private String defaultFilemode;
    private String defaultDirmode;
    private String defaultUsername;
    private String defaultGroupname;
    private File buildroot;
    private String version;
    private String changelog;
    private File changelogFile;

    AbstractRPMMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParams();
        String classifier = this.getClassifier();
        this.workarea = classifier != null ? new File(this.workarea, this.name + '-' + classifier) : new File(this.workarea, this.name);
        this.buildWorkArea();
        this.installFiles();
        this.writeSpecFile();
        this.buildPackage();
        this.afterExecution();
    }

    protected void afterExecution() throws MojoExecutionException, MojoFailureException {
    }

    String getClassifier() {
        return null;
    }

    protected File getRPMFile() {
        File rpms = new File(this.workarea, "RPMS");
        File archDir = new File(rpms, this.targetArch);
        return new File(archDir, this.name + '-' + this.version + '-' + this.release + '.' + this.targetArch + ".rpm");
    }

    private String getHostVendor() throws MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("rpm");
        cl.addArguments(new String[]{"-E", "%{_host_vendor}"});
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        LogStreamConsumer stderr = new LogStreamConsumer(2, this.getLog());
        try {
            int result;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("RPM query for default vendor returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to query for default vendor from RPM", (Exception)((Object)e));
        }
        return stdout.getOutput().trim();
    }

    private void buildPackage() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        Commandline cl = new Commandline();
        cl.setExecutable("rpmbuild");
        cl.setWorkingDirectory(f.getAbsolutePath());
        cl.createArg().setValue("-bb");
        cl.createArg().setValue("--buildroot");
        cl.createArg().setValue(this.buildroot.getAbsolutePath());
        cl.createArg().setValue("--define");
        cl.createArg().setValue("_topdir " + this.workarea.getAbsolutePath());
        cl.createArg().setValue("--target");
        cl.createArg().setValue(this.targetArch + '-' + this.targetVendor + '-' + this.targetOS);
        if (this.keyname != null && this.keyPassphrase == null) {
            cl.createArg().setValue("--define");
            cl.createArg().setValue("_gpg_name " + this.keyname);
            cl.createArg().setValue("--sign");
        }
        cl.createArg().setValue(this.name + ".spec");
        LogStreamConsumer stdout = new LogStreamConsumer(1, this.getLog());
        LogStreamConsumer stderr = new LogStreamConsumer(2, this.getLog());
        try {
            int result;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("RPM build execution returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to build the RPM", (Exception)((Object)e));
        }
        if (this.keyname != null && this.keyPassphrase != null) {
            RPMSigner signer = new RPMSigner(this.keyname, this.keyPassphrase.getPassphrase(), this.getLog());
            try {
                signer.sign(this.getRPMFile());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to sign RPM", e);
            }
        }
    }

    private void buildWorkArea() throws MojoFailureException {
        String[] topdirs = new String[]{"BUILD", "RPMS", "SOURCES", "SPECS", "SRPMS"};
        if (!this.workarea.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.workarea.getAbsolutePath()));
            if (!this.workarea.mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + this.workarea.getAbsolutePath());
            }
        }
        for (int i = 0; i < topdirs.length; ++i) {
            File d = new File(this.workarea, topdirs[i]);
            if (d.exists()) continue;
            this.getLog().info((CharSequence)("Creating directory " + d.getAbsolutePath()));
            if (d.mkdir()) continue;
            throw new MojoFailureException("Unable to create directory " + d.getAbsolutePath());
        }
        this.buildroot = new File(this.workarea, "buildroot");
        if (!this.buildroot.exists() && !this.buildroot.mkdirs()) {
            throw new MojoFailureException("Unable to create directory: " + this.buildroot.getAbsolutePath());
        }
    }

    private void checkParams() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.debug((CharSequence)("project version = " + this.projversion));
        int modifierIndex = this.projversion.indexOf(45);
        if (modifierIndex == -1) {
            this.version = this.projversion;
            if (this.release == null || this.release.length() == 0) {
                this.release = "1";
                log.debug((CharSequence)"Release set to: 1");
            }
        } else {
            this.version = this.projversion.substring(0, modifierIndex);
            log.warn((CharSequence)("Version string truncated to " + this.version));
            if (this.release == null || this.release.length() == 0) {
                String modifier = this.projversion.substring(modifierIndex + 1, this.projversion.length());
                log.debug((CharSequence)("version modifier = " + modifier));
                modifier = modifier.replace('-', '_');
                if (modifier.endsWith("SNAPSHOT")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifier = modifier + simpleDateFormat.format(new Date());
                } else {
                    modifier = modifier + "_1";
                }
                this.release = modifier;
                log.debug((CharSequence)("Release set to: " + modifier));
            }
        }
        this.targetArch = this.needarch == null || this.needarch.length() == 0 || "false".equalsIgnoreCase(this.needarch) ? "noarch" : ("true".equalsIgnoreCase(this.needarch) ? Os.OS_ARCH : this.needarch);
        log.debug((CharSequence)("targetArch = " + this.targetArch));
        if (this.targetOS == null || this.targetOS.length() == 0) {
            this.targetOS = Os.OS_NAME;
        }
        log.debug((CharSequence)("targetOS = " + this.targetOS));
        if (this.targetVendor == null || this.targetVendor.length() == 0) {
            this.targetVendor = this.getHostVendor();
        }
        log.debug((CharSequence)("targetVendor = " + this.targetVendor));
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            Mapping map = (Mapping)it.next();
            if (map.getDirectory() == null) {
                throw new MojoFailureException("<mapping> element must contain the destination directory");
            }
            if (map.getSources() == null) continue;
            Iterator sit = map.getSources().iterator();
            while (sit.hasNext()) {
                Source src = (Source)sit.next();
                if (src.getLocation() != null) continue;
                throw new MojoFailureException("<mapping><source> tag must contain the source directory");
            }
        }
        this.prepareScriptlet = this.passiveScripts("prepare", this.prepareScriptlet, this.prepare, this.prepareScript);
        this.preinstallScriptlet = this.passiveScripts("preinstall", this.preinstallScriptlet, this.preinstall, this.preinstallScript);
        this.installScriptlet = this.passiveScripts("install", this.installScriptlet, this.install, this.installScript);
        this.postinstallScriptlet = this.passiveScripts("postinstall", this.postinstallScriptlet, this.postinstall, this.postinstallScript);
        this.preremoveScriptlet = this.passiveScripts("preremove", this.preremoveScriptlet, this.preremove, this.preremoveScript);
        this.postremoveScriptlet = this.passiveScripts("postremove", this.postremoveScriptlet, this.postremove, this.postremoveScript);
        this.verifyScriptlet = this.passiveScripts("verify", this.verifyScriptlet, this.verify, this.verifyScript);
        this.cleanScriptlet = this.passiveScripts("clean", this.cleanScriptlet, this.clean, this.cleanScript);
        if (this.changelog == null && this.changelogFile != null) {
            if (!this.changelogFile.exists()) {
                log.debug((CharSequence)(this.changelogFile.getAbsolutePath() + " does not exist - ignoring"));
            } else {
                try {
                    StringBuffer sb = new StringBuffer();
                    BufferedReader br = new BufferedReader(new FileReader(this.changelogFile));
                    while (br.ready()) {
                        String line = br.readLine();
                        sb.append(line);
                        sb.append('\n');
                    }
                    br.close();
                    this.changelog = sb.toString();
                }
                catch (Throwable t) {
                    throw new MojoExecutionException("Unable to read " + this.changelogFile.getAbsolutePath(), t);
                }
            }
        }
    }

    private final Scriptlet passiveScripts(String name, Scriptlet scriptlet, String script, File file) {
        if (scriptlet == null && (script != null || file != null)) {
            scriptlet = new Scriptlet();
            scriptlet.setScript(script);
            scriptlet.setScriptFile(file);
            this.getLog().warn((CharSequence)("Deprecated <" + name + "> and/or <" + name + "Script> used - should use <" + name + "Scriptlet>"));
        }
        return scriptlet;
    }

    private String copyArtifact(Artifact art, File dest, boolean stripVersion) throws MojoExecutionException {
        String outputFileName;
        if (art.getFile() == null) {
            this.getLog().warn((CharSequence)("Artifact " + art + " requested in configuration."));
            this.getLog().warn((CharSequence)"Plugin must run in standard lifecycle for this to work.");
            return null;
        }
        if (stripVersion) {
            String classifier = art.getClassifier();
            outputFileName = art.getArtifactId();
            if (classifier != null) {
                outputFileName = outputFileName + '-';
                outputFileName = outputFileName + classifier;
            }
            outputFileName = outputFileName + '.';
            outputFileName = outputFileName + art.getType();
        } else {
            outputFileName = art.getFile().getName();
        }
        this.copySource(art.getFile(), outputFileName, dest, null, null);
        return outputFileName;
    }

    private List copySource(File src, String srcName, File dest, List incl, List excl) throws MojoExecutionException {
        try {
            this.copier.setDestFile(dest);
            if (src.isDirectory()) {
                String[] ia = null;
                if (incl != null) {
                    ia = incl.toArray(new String[0]);
                }
                String[] ea = null;
                if (excl != null) {
                    ea = excl.toArray(new String[0]);
                }
                this.copier.addDirectory(src, "", ia, ea);
            } else {
                srcName = srcName != null ? srcName : src.getName();
                this.copier.addFile(src, srcName);
            }
            this.copier.createArchive();
            Map copiedFilesMap = this.copier.getFiles();
            ArrayList<String> copiedFiles = new ArrayList<String>(copiedFilesMap.size());
            Iterator i = copiedFilesMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key == null || key.length() <= 0) continue;
                copiedFiles.add(key);
            }
            this.copier.resetArchiver();
            return copiedFiles;
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to copy files for packaging: " + t.getMessage(), t);
        }
    }

    private boolean depMatcher(Artifact dep, List list) {
        if (list == null) {
            return false;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Artifact item = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Compare " + dep + " to " + item));
            if (!StringUtils.isEmpty((String)item.getGroupId()) && !item.getGroupId().equals(dep.getGroupId())) continue;
            this.getLog().debug((CharSequence)"... Group matches");
            if (!StringUtils.isEmpty((String)item.getArtifactId()) && !item.getArtifactId().equals(dep.getArtifactId())) continue;
            this.getLog().debug((CharSequence)"... Artifact matches");
            try {
                if (!item.getVersionRange().containsVersion(dep.getSelectedVersion())) continue;
                this.getLog().debug((CharSequence)"... Version matches");
                return true;
            }
            catch (OverConstrainedVersionException ocve) {
                this.getLog().debug((CharSequence)"... caught OverConstrainedVersionException");
            }
        }
        return false;
    }

    private void installFiles() throws MojoExecutionException, MojoFailureException {
        if (this.icon != null) {
            File icondest = new File(this.workarea, "SOURCES");
            this.copySource(this.icon, null, icondest, null, null);
        }
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            Dependency dep;
            Mapping map = (Mapping)it.next();
            File dest = new File(this.buildroot + map.getDestination());
            if (map.isDirOnly()) {
                if (dest.exists()) continue;
                this.getLog().info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
                if (dest.mkdirs()) continue;
                throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
            }
            this.processSources(map, dest);
            ArtifactMap art = map.getArtifact();
            if (art != null) {
                List artlist = this.selectArtifacts(art);
                Iterator ait = artlist.iterator();
                while (ait.hasNext()) {
                    Artifact artifactInstance = (Artifact)ait.next();
                    this.copyArtifact(artifactInstance, dest, false);
                    map.addCopiedFileNameRelativeToDestination(artifactInstance.getFile().getName());
                }
            }
            if ((dep = map.getDependency()) != null) {
                List deplist = this.selectDependencies(dep);
                Iterator dit = deplist.iterator();
                while (dit.hasNext()) {
                    Artifact artifactInstance = (Artifact)dit.next();
                    String outputFileName = this.copyArtifact(artifactInstance, dest, dep.getStripVersion());
                    map.addCopiedFileNameRelativeToDestination(outputFileName);
                }
            }
            if (!map.getCopiedFileNamesRelativeToDestination().isEmpty()) continue;
            this.getLog().info((CharSequence)("Mapping empty with destination: " + dest.getName()));
            if (dest.exists()) continue;
            this.getLog().info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
            if (dest.mkdirs()) continue;
            throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSources(Mapping map, File dest) throws MojoExecutionException, MojoFailureException {
        List srcs;
        if (!dest.exists() && !dest.mkdirs()) {
            throw new MojoExecutionException("unable to create directory: " + dest.getAbsolutePath());
        }
        String relativeDestination = map.getDestination();
        if (!relativeDestination.endsWith(File.separator)) {
            relativeDestination = relativeDestination + File.separatorChar;
        }
        if ((srcs = map.getSources()) != null) {
            String targetArchComparison = this.targetArch.toLowerCase(Locale.ENGLISH);
            Iterator sit = srcs.iterator();
            while (sit.hasNext()) {
                Source src = (Source)sit.next();
                if (!src.matchesArchitecture(targetArchComparison)) {
                    this.getLog().debug((CharSequence)("Source does not match target architecture: " + src.toString()));
                    continue;
                }
                if (!src.matchesOSName(this.targetOS)) {
                    this.getLog().debug((CharSequence)("Source does not match target os name: " + src.toString()));
                    continue;
                }
                File location = src.getLocation();
                if (src instanceof SoftlinkSource) {
                    LinkedList<Source> sources = (LinkedList<Source>)this.linkTargetToSources.get(relativeDestination);
                    if (sources == null) {
                        sources = new LinkedList<Source>();
                        this.linkTargetToSources.put(relativeDestination, sources);
                    }
                    sources.add(src);
                    ((SoftlinkSource)src).setSourceMapping(map);
                    map.setHasSoftLinks(true);
                    continue;
                }
                if (location.exists()) {
                    String destination = src.getDestination();
                    if (destination == null) {
                        ArrayList elist = src.getExcludes();
                        if (!src.getNoDefaultExcludes()) {
                            if (elist == null) {
                                elist = new ArrayList();
                            }
                            elist.addAll(FileUtils.getDefaultExcludesAsList());
                        }
                        List copiedFiles = this.copySource(src.getLocation(), null, dest, src.getIncludes(), elist);
                        map.addCopiedFileNamesRelativeToDestination(copiedFiles);
                        continue;
                    }
                    if (!location.isFile()) {
                        throw new MojoExecutionException(MessageFormat.format(DESTINATION_DIRECTORY_ERROR_MSG, destination, location.getName()));
                    }
                    File destFile = new File(dest, destination);
                    try {
                        if (!destFile.createNewFile()) {
                            throw new IOException("Unable to create file: " + destFile.getAbsolutePath());
                        }
                        FileInputStream fis = new FileInputStream(location);
                        try {
                            FileOutputStream fos = new FileOutputStream(destFile);
                            try {
                                fis.getChannel().transferTo(0L, location.length(), fos.getChannel());
                            }
                            finally {
                                fos.close();
                            }
                        }
                        finally {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to copy files", (Exception)e);
                    }
                    map.addCopiedFileNameRelativeToDestination(destination);
                    continue;
                }
                throw new MojoExecutionException("Source location " + location + " does not exist");
            }
        }
    }

    private List selectArtifacts(ArtifactMap am) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List clist = am.getClassifiers();
        if (clist == null) {
            retval.add(this.artifact);
            retval.addAll(this.attachedArtifacts);
        } else {
            if (clist.contains(null)) {
                retval.add(this.artifact);
            }
            Iterator ait = this.attachedArtifacts.iterator();
            while (ait.hasNext()) {
                Artifact aa = (Artifact)ait.next();
                if (!aa.hasClassifier() || !clist.contains(aa.getClassifier())) continue;
                retval.add(aa);
            }
        }
        return retval;
    }

    private List selectDependencies(Dependency d) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List inc = d.getIncludes();
        List exc = d.getExcludes();
        Set deps = this.project.getArtifacts();
        if (deps == null || deps.isEmpty()) {
            return retval;
        }
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Artifact pdep = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Dependency is " + pdep + " at " + pdep.getFile()));
            if (this.depMatcher(pdep, exc)) continue;
            this.getLog().debug((CharSequence)"--> not excluded");
            if (inc != null && !this.depMatcher(pdep, inc)) continue;
            this.getLog().debug((CharSequence)"--> included");
            retval.add(pdep);
        }
        return retval;
    }

    private void writeSpecFile() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        File specf = new File(f, this.name + ".spec");
        try {
            String copyrightText;
            this.getLog().info((CharSequence)("Creating spec file " + specf.getAbsolutePath()));
            PrintWriter spec = new PrintWriter(new FileWriter(specf));
            AbstractRPMMojo.writeList(spec, this.defineStatements, "%define ");
            spec.println("Name: " + this.name);
            spec.println("Version: " + this.version);
            spec.println("Release: " + this.release);
            if (this.summary != null) {
                spec.println("Summary: " + this.summary);
            }
            if ((copyrightText = this.copyright) == null) {
                copyrightText = this.generateCopyrightText();
            }
            if (copyrightText != null) {
                spec.println("License: " + copyrightText);
            }
            if (this.distribution != null) {
                spec.println("Distribution: " + this.distribution);
            }
            if (this.icon != null) {
                spec.println("Icon: " + this.icon.getName());
            }
            if (this.vendor != null) {
                spec.println("Vendor: " + this.vendor);
            }
            if (this.url != null) {
                spec.println("URL: " + this.url);
            }
            if (this.group != null) {
                spec.println("Group: " + this.group);
            }
            if (this.packager != null) {
                spec.println("Packager: " + this.packager);
            }
            if (this.obsoletes != null) {
                if (this.provides == null) {
                    this.provides = this.obsoletes;
                } else {
                    this.provides.addAll(this.obsoletes);
                }
            }
            AbstractRPMMojo.writeList(spec, this.provides, "Provides: ");
            AbstractRPMMojo.writeList(spec, this.requires, "Requires: ");
            AbstractRPMMojo.writeList(spec, this.prereqs, "PreReq: ");
            AbstractRPMMojo.writeList(spec, this.obsoletes, "Obsoletes: ");
            AbstractRPMMojo.writeList(spec, this.conflicts, "Conflicts: ");
            spec.println("autoprov: " + (this.autoProvides ? "yes" : "no"));
            spec.println("autoreq: " + (this.autoRequires ? "yes" : "no"));
            if (this.prefix != null) {
                spec.println("Prefix: " + this.prefix);
            }
            spec.println("BuildRoot: " + this.buildroot.getAbsolutePath());
            spec.println();
            spec.println("%description");
            if (this.description != null) {
                spec.println(this.description);
            }
            boolean printedInstall = false;
            if (!this.linkTargetToSources.isEmpty()) {
                if (!printedInstall) {
                    spec.println();
                    spec.println("%install");
                    printedInstall = true;
                }
                Iterator entryIter = this.linkTargetToSources.entrySet().iterator();
                while (entryIter.hasNext()) {
                    List sources;
                    int sourceCnt;
                    Map.Entry directoryToSourcesEntry = entryIter.next();
                    String directory = (String)directoryToSourcesEntry.getKey();
                    if (directory.startsWith("/")) {
                        directory = directory.substring(1);
                    }
                    if (directory.endsWith("/")) {
                        directory = directory.substring(0, directory.length() - 1);
                    }
                    if ((sourceCnt = (sources = (List)directoryToSourcesEntry.getValue()).size()) == 1) {
                        SoftlinkSource linkSource = (SoftlinkSource)sources.get(0);
                        File sourceLocation = linkSource.getLocation();
                        File buildSourceLocation = new File(this.buildroot, sourceLocation.getAbsolutePath());
                        if (buildSourceLocation.isDirectory()) {
                            DirectoryScanner scanner = this.scanLinkSource(linkSource, buildSourceLocation);
                            if (scanner.isEverythingIncluded()) {
                                File destinationFile = new File(this.buildroot, directory);
                                destinationFile.delete();
                                spec.print("ln -s ");
                                spec.print(sourceLocation.getAbsolutePath());
                                spec.print(" $RPM_BUILD_ROOT/");
                                spec.print(directory);
                                String dest = linkSource.getDestination();
                                if (dest != null) {
                                    spec.print('/');
                                    spec.print(dest);
                                    linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(dest);
                                }
                                spec.println();
                                continue;
                            }
                            this.linkScannedFiles(spec, directory, linkSource, scanner);
                            continue;
                        }
                        this.linkSingleFile(spec, directory, linkSource);
                        continue;
                    }
                    Iterator sourceIter = sources.iterator();
                    while (sourceIter.hasNext()) {
                        SoftlinkSource linkSource = (SoftlinkSource)sourceIter.next();
                        File sourceLocation = linkSource.getLocation();
                        File buildSourceLocation = new File(this.buildroot, sourceLocation.getAbsolutePath());
                        if (buildSourceLocation.isDirectory()) {
                            DirectoryScanner scanner = this.scanLinkSource(linkSource, buildSourceLocation);
                            this.linkScannedFiles(spec, directory, linkSource, scanner);
                            continue;
                        }
                        this.linkSingleFile(spec, directory, linkSource);
                    }
                }
            }
            if (this.installScriptlet != null) {
                if (!printedInstall) {
                    this.installScriptlet.write(spec, "%install");
                } else {
                    spec.println();
                    this.installScriptlet.writeContent(spec);
                }
            }
            spec.println();
            spec.println("%files");
            spec.println(this.getDefAttrString());
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                Mapping map = (Mapping)it.next();
                String destination = map.getDestination();
                File absoluteDestination = new File(this.buildroot, destination);
                if (map.hasSoftLinks() && !absoluteDestination.exists()) {
                    this.getLog().debug((CharSequence)("writing attribute string for directory created by soft link: " + destination));
                    String attributes = map.getAttrString(this.defaultFilemode, this.defaultGroupname, this.defaultUsername);
                    spec.print(attributes);
                    spec.print(' ');
                    spec.println(destination);
                    continue;
                }
                List includes = map.getCopiedFileNamesRelativeToDestination();
                List links = map.getLinkedFileNamesRelativeToDestination();
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(absoluteDestination);
                scanner.setIncludes(includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
                scanner.setExcludes(null);
                scanner.scan();
                String attrString = map.getAttrString(this.defaultFilemode, this.defaultGroupname, this.defaultUsername);
                if (scanner.isEverythingIncluded() && links.isEmpty() && map.isDirectoryIncluded()) {
                    this.getLog().debug((CharSequence)("writing attriute string for directory: " + destination));
                    spec.println(attrString + " " + destination);
                    continue;
                }
                this.getLog().debug((CharSequence)("writing attribute string for identified files in directory: " + destination));
                String[] files = scanner.getIncludedFiles();
                String baseFileString = attrString + " " + destination + File.separatorChar;
                for (int i = 0; i < files.length; ++i) {
                    spec.print(baseFileString);
                    spec.println(files[i]);
                }
                Iterator linkIter = links.iterator();
                while (linkIter.hasNext()) {
                    String link = (String)linkIter.next();
                    spec.print(baseFileString);
                    spec.println(link);
                }
            }
            this.printScripts(spec);
            if (this.triggers != null) {
                Iterator i = this.triggers.iterator();
                while (i.hasNext()) {
                    BaseTrigger trigger = (BaseTrigger)i.next();
                    trigger.writeTrigger(spec);
                }
            }
            this.printChangelog(spec);
            spec.close();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to write " + specf.getAbsolutePath(), t);
        }
    }

    private void linkScannedFiles(PrintWriter spec, String directory, SoftlinkSource linkSource, DirectoryScanner scanner) {
        String[] files = scanner.getIncludedFiles();
        File sourceLocation = linkSource.getLocation();
        String targetPrefix = sourceLocation.getAbsolutePath() + File.separatorChar;
        String sourcePrefix = directory + File.separatorChar;
        for (int i = 0; i < files.length; ++i) {
            spec.print("ln -s ");
            spec.print(targetPrefix + files[i]);
            spec.print(" $RPM_BUILD_ROOT/");
            spec.println(sourcePrefix + files[i]);
            linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(files[i]);
        }
    }

    private DirectoryScanner scanLinkSource(SoftlinkSource linkSource, File buildSourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(buildSourceLocation);
        List includes = linkSource.getIncludes();
        scanner.setIncludes(includes == null || includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
        List excludes = linkSource.getExcludes();
        scanner.setExcludes(excludes == null || excludes.isEmpty() ? null : excludes.toArray(new String[excludes.size()]));
        scanner.scan();
        return scanner;
    }

    private void linkSingleFile(PrintWriter spec, String directory, SoftlinkSource linkSource) {
        File sourceLocation = linkSource.getLocation();
        spec.print("ln -s ");
        spec.print(sourceLocation.getAbsolutePath());
        spec.print(" $RPM_BUILD_ROOT/");
        spec.print(directory);
        spec.print('/');
        String destination = linkSource.getDestination();
        String linkedFileName = destination == null ? sourceLocation.getName() : destination;
        spec.println(linkedFileName);
        linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(linkedFileName);
    }

    private void printChangelog(PrintWriter writer) {
        if (this.changelog != null) {
            writer.println();
            writer.println("%changelog");
            writer.println(this.changelog);
        }
    }

    private void printScripts(PrintWriter writer) throws IOException {
        if (this.prepareScriptlet != null) {
            this.prepareScriptlet.write(writer, "%prep");
        }
        if (this.pretransScriptlet != null) {
            this.pretransScriptlet.write(writer, "%pretrans");
        }
        if (this.preinstallScriptlet != null) {
            this.preinstallScriptlet.write(writer, "%pre");
        }
        if (this.postinstallScriptlet != null) {
            this.postinstallScriptlet.write(writer, "%post");
        }
        if (this.preremoveScriptlet != null) {
            this.preremoveScriptlet.write(writer, "%preun");
        }
        if (this.postremoveScriptlet != null) {
            this.postremoveScriptlet.write(writer, "%postun");
        }
        if (this.posttransScriptlet != null) {
            this.posttransScriptlet.write(writer, "%posttrans");
        }
        if (this.verifyScriptlet != null) {
            this.verifyScriptlet.write(writer, "%verifyscript");
        }
        if (this.cleanScriptlet != null) {
            this.cleanScriptlet.write(writer, "%clean");
        }
    }

    private static void writeList(PrintWriter writer, Collection strings, String prefix) {
        if (strings != null) {
            Iterator it = strings.iterator();
            while (it.hasNext()) {
                writer.print(prefix);
                writer.println(it.next());
            }
        }
    }

    private String generateCopyrightText() {
        String organization;
        String year = this.project.getInceptionYear();
        String string = organization = this.project.getOrganization() == null ? null : this.project.getOrganization().getName();
        String copyrightText = year != null && organization != null ? year + " " + organization : (year == null ? organization : year);
        return copyrightText;
    }

    private String getDefAttrString() {
        if (this.defaultFilemode == null && this.defaultUsername == null && this.defaultGroupname == null && this.defaultDirmode == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.defaultFilemode != null) {
            sb.append("%defattr(").append(this.defaultFilemode).append(",");
        } else {
            sb.append("%defattr(-,");
        }
        if (this.defaultUsername != null) {
            sb.append(this.defaultUsername).append(",");
        } else {
            sb.append("-,");
        }
        if (this.defaultGroupname != null) {
            sb.append(this.defaultGroupname).append(",");
        } else {
            sb.append("-,");
        }
        if (this.defaultDirmode != null) {
            sb.append(this.defaultDirmode).append(")");
        } else {
            sb.append("-)");
        }
        return sb.toString();
    }
}

