/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.List;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.Dependency;

public class Mapping {
    private String directory;
    private boolean configuration;
    private boolean documentation;
    private String filemode;
    private String username;
    private String groupname;
    private List sources;
    private ArtifactMap artifact;
    private Dependency dependency;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String dir) {
        this.directory = dir;
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(boolean isCfg) {
        this.configuration = isCfg;
    }

    public boolean isDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(boolean isDoc) {
        this.documentation = isDoc;
    }

    public String getFilemode() {
        return this.filemode;
    }

    public void setFilemode(String fmode) {
        this.filemode = fmode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String uname) {
        this.username = uname;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String grpname) {
        this.groupname = grpname;
    }

    public List getSources() {
        return this.sources;
    }

    public void setSources(List srclist) {
        this.sources = srclist;
    }

    public ArtifactMap getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArtifactMap am) {
        this.artifact = am;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency am) {
        this.dependency = am;
    }

    public String getAttrString() {
        StringBuffer sb = new StringBuffer();
        if (this.configuration) {
            sb.append("%config ");
        }
        if (this.documentation) {
            sb.append("%doc ");
        }
        if ((this.sources == null || this.sources.size() == 0) && this.dependency == null && this.artifact == null) {
            sb.append("%dir ");
        }
        if (this.filemode != null) {
            sb.append("%attr(" + this.filemode + ",");
        } else {
            sb.append("%attr(-,");
        }
        if (this.username != null) {
            sb.append(this.username + ",");
        } else {
            sb.append("-,");
        }
        if (this.groupname != null) {
            sb.append(this.groupname + ")");
        } else {
            sb.append("-)");
        }
        return sb.toString();
    }

    public String getDestination() {
        if (this.directory == null) {
            return "nowhere";
        }
        return this.directory;
    }

    public boolean isDirOnly() {
        if (this.sources != null && !this.sources.isEmpty()) {
            return false;
        }
        if (this.artifact != null) {
            return false;
        }
        return this.dependency == null;
    }

    public String toString() {
        boolean sourceShown = false;
        StringBuffer sb = new StringBuffer();
        sb.append("[\"" + this.getDestination() + "\" ");
        sb.append("{" + this.getAttrString() + "}");
        if (this.isDirOnly()) {
            sb.append(" (dir only)]");
        } else {
            sb.append(" from ");
            if (this.sources != null) {
                sb.append(this.sources.toString());
                sourceShown = true;
            }
            if (this.artifact != null) {
                if (sourceShown) {
                    sb.append(", ");
                }
                sb.append(this.artifact.toString());
                sourceShown = true;
            }
            if (this.dependency != null) {
                if (sourceShown) {
                    sb.append(", ");
                }
                sb.append(this.dependency.toString());
                sourceShown = true;
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

