/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.ProjectRpmFileManager;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.plexus.context.Context;

public class SetRpmProjectArtifactFileMojo
extends AbstractMojo {
    private String platformPostfix;
    private boolean skipPlatformPostfix;
    private String rpmName;
    private File rpmFile;
    private MavenProject project;
    private String release;
    private File topDir;
    private MavenSession session;
    private RpmInfoFormatter rpmInfoFormatter;
    private ProjectRpmFileManager projectRpmFileManager;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (BuildAdvisor.isProjectBuildSkipped((MavenProject)this.project, (Context)this.session.getContainer().getContext())) {
            this.getLog().info((CharSequence)"Skipping execution per pre-existing advice.");
            return;
        }
        if (this.rpmFile != null) {
            this.getLog().info((CharSequence)("Using overridden RPM file location: " + this.rpmFile));
            this.projectRpmFileManager.setProjectArtifactFile(this.project, this.rpmFile);
        } else {
            void var1_1;
            String rpmBaseName;
            if (this.rpmName != null && this.rpmName.trim().length() > 0) {
                rpmBaseName = this.rpmName;
            } else {
                try {
                    rpmBaseName = this.rpmInfoFormatter.formatRpmName(this.project, this.release, this.platformPostfix, this.skipPlatformPostfix);
                }
                catch (RpmFormattingException e) {
                    throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)((Object)e));
                }
            }
            this.projectRpmFileManager.formatAndSetProjectArtifactFile(this.project, this.topDir, (String)var1_1);
        }
    }
}

