/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.antcall.AntCallLogger;
import org.codehaus.mojo.tools.antcall.MojoLogAdapter;
import org.codehaus.mojo.tools.rpm.RpmConstants;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.mojo.tools.rpm.RpmInstallException;
import org.codehaus.mojo.tools.rpm.RpmMediator;

public class RemoveRpmMojo
extends AbstractMojo {
    private boolean useSudo;
    private boolean skipRemove;
    private List projects;
    private MavenProject project;
    private static boolean completed = false;
    private String rpmDbPath;
    private RpmInfoFormatter rpmInfoFormatter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipRemove) {
            this.getLog().info((CharSequence)"Skipping RPM removal (per configuration).");
            return;
        }
        if (completed) {
            this.getLog().info((CharSequence)"RPM erase has completed. Skipping this invocation.");
            return;
        }
        if (this.projects != null && !this.projects.isEmpty()) {
            this.getLog().info((CharSequence)("Removing " + this.projects.size() + " project RPMs."));
            ArrayList projectsInReverseOrder = new ArrayList(this.projects);
            Collections.reverse(projectsInReverseOrder);
            Iterator it = projectsInReverseOrder.iterator();
            while (it.hasNext()) {
                MavenProject project = (MavenProject)it.next();
                if (!RpmConstants.RPM_PACKAGINGS.contains(project.getPackaging())) continue;
                this.remove(project);
            }
        } else {
            this.getLog().info((CharSequence)"Removing single project RPM.");
            this.remove(this.project);
        }
        completed = true;
    }

    private void remove(MavenProject project) throws MojoExecutionException {
        String rpmBaseName;
        this.getLog().info((CharSequence)("Removing: " + project.getId()));
        try {
            rpmBaseName = this.rpmInfoFormatter.formatRpmNameWithoutVersion(project);
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        RpmMediator installer = new RpmMediator(this.useSudo, (AntCallLogger)new MojoLogAdapter(this.getLog()));
        try {
            installer.remove(rpmBaseName, this.rpmDbPath);
        }
        catch (RpmInstallException e) {
            throw new MojoExecutionException("Failed to install project RPM for: " + project, (Exception)((Object)e));
        }
    }
}

