/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class ProjectRpmFileManager
implements LogEnabled {
    private RpmInfoFormatter rpmInfoFormatter;
    private Logger logger;

    public void formatAndSetProjectArtifactFile(MavenProject project, File topDir, String rpmBaseName) throws MojoExecutionException {
        File artifactFile;
        File rpmsDir;
        try {
            rpmsDir = new File(topDir, "RPMS/" + this.rpmInfoFormatter.formatPlatformArchitecture());
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot format OS architecture name for RPM directory structure.", (Exception)((Object)e));
        }
        try {
            artifactFile = new File(rpmsDir, rpmBaseName + "." + this.rpmInfoFormatter.formatPlatformArchitecture() + ".rpm");
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot read OS architecture from rpm command.", (Exception)((Object)e));
        }
        this.setProjectArtifactFile(project, artifactFile);
    }

    public void setProjectArtifactFile(MavenProject project, File artifactFile) {
        Artifact projectArtifact = project.getArtifact();
        projectArtifact.setFile(artifactFile);
        this.getLogger().info("Project artifact set to file: " + artifactFile);
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

