/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.AbstractRpmInstallMojo;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInstallException;

public class InstallRpmMojo
extends AbstractRpmInstallMojo {
    private boolean skipInstall;
    private boolean forceInstall;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipInstall) {
            this.getLog().info((CharSequence)"Skipping RPM build (per configuration).");
            return;
        }
        File rpmFile = this.project.getArtifact().getFile();
        if (rpmFile == null) {
            throw new MojoFailureException((Object)this, "RPM file does not exist.", "RPM file has not been set on project artifact for: " + this.project.getId());
        }
        if (!rpmFile.exists()) {
            throw new MojoFailureException((Object)this, "RPM file does not exist.", "Cannot install missing RPM: " + rpmFile);
        }
        try {
            this.install(this.project, this.forceInstall);
        }
        catch (RpmInstallException e) {
            throw new MojoExecutionException("Failed to install project RPM for: " + this.project, (Exception)((Object)e));
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Failed to install project RPM for: " + this.project, (Exception)((Object)e));
        }
    }
}

