/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.mojo.tools.rpm.RpmSpecFormatter;
import org.codehaus.plexus.context.Context;

public class GenerateSpecFileMojo
extends AbstractMojo {
    private boolean skip;
    private String platformPostfix;
    private boolean skipPlatformPostfix;
    private Artifact projectArtifact;
    private List dependencies;
    private List providesExclusions;
    private List dependsExclusions;
    private MavenProject project;
    private String rpmName;
    private File topDir;
    private File destDir;
    private String prefix;
    private String release;
    private boolean rpmNoStrip;
    private File preInstallFile;
    private File postUninstallFile;
    private File preUninstallFile;
    private File postInstallFile;
    private MavenSession session;
    private RpmSpecFormatter rpmSpecFormatter;
    private RpmInfoFormatter rpmInfoFormatter;

    public void execute() throws MojoExecutionException {
        String spec;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping generation of RPM spec file (per configuration).");
            return;
        }
        if (BuildAdvisor.isProjectBuildSkipped((MavenProject)this.project, (Context)this.session.getContainer().getContext())) {
            this.getLog().info((CharSequence)"Skipping execution per pre-existing advice.");
            return;
        }
        HashSet<Dependency> depends = new HashSet<Dependency>();
        Set<Artifact> provides = Collections.singleton(this.projectArtifact);
        this.getLog().warn((CharSequence)"Assuming all dependencies are real RPM dependencies. Provides statement is not currently being populated.");
        Iterator it = this.dependencies.iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            depends.add(dependency);
        }
        this.processExclusions(provides, depends);
        try {
            spec = this.rpmSpecFormatter.buildSpec(this.project, this.session.getLocalRepository(), depends, provides, this.destDir, this.prefix, this.release, this.rpmNoStrip, this.preInstallFile, this.postInstallFile, this.postUninstallFile, this.preUninstallFile, this.platformPostfix, this.skipPlatformPostfix);
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Failed to build RPM spec file. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        this.writeSpecFile(spec);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSpecFile(String spec) throws MojoExecutionException {
        void var2_2;
        String specFileName;
        if (this.rpmName != null && this.rpmName.trim().length() > 0) {
            specFileName = this.rpmName + ".spec";
        } else {
            try {
                specFileName = this.rpmInfoFormatter.formatRpmName(this.project, this.release, this.platformPostfix, this.skipPlatformPostfix) + ".spec";
            }
            catch (RpmFormattingException e) {
                throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        File specDir = new File(this.topDir, "SPECS");
        specDir.mkdirs();
        File specFile = new File(specDir, (String)var2_2);
        FileWriter writer = null;
        writer = new FileWriter(specFile);
        writer.write(spec);
        ((Writer)writer).flush();
        Object var8_7 = null;
        if (writer == null) return;
        try {
            ((Writer)writer).close();
            return;
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Failed to close spec-file writer.", (Throwable)e);
        }
        return;
        {
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write spec file: " + specFile, (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (writer == null) throw throwable;
            try {
                ((Writer)writer).close();
                throw throwable;
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)"Failed to close spec-file writer.", (Throwable)e);
            }
            throw throwable;
        }
    }

    private void processExclusions(Set provides, Set depends) {
        Dependency excluded;
        String key;
        Iterator it;
        Map dependencyMap = this.getDependencyMap();
        if (this.providesExclusions != null) {
            it = this.providesExclusions.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                excluded = (Dependency)dependencyMap.get(key);
                provides.remove(excluded);
            }
        }
        if (this.dependsExclusions != null) {
            it = this.dependsExclusions.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                excluded = (Dependency)dependencyMap.get(key);
                depends.remove(excluded);
            }
        }
    }

    private Map getDependencyMap() {
        HashMap<String, Dependency> deps = new HashMap<String, Dependency>();
        Iterator it = this.dependencies.iterator();
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            String key = ArtifactUtils.versionlessKey((String)dep.getGroupId(), (String)dep.getArtifactId());
            deps.put(key, dep);
        }
        return deps;
    }
}

