/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.retrotranslator;

import java.io.File;
import net.sf.retrotranslator.transformer.Retrotranslator;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.retrotranslator.AttachingMojoSupport;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class TranslateWarMojo
extends AttachingMojoSupport {
    private DirectoryScanner jarfileset;
    private WarArchiver warArchiver;
    private File transformedWarDir;

    protected void doExecute() throws Exception {
        if (!"war".equals(this.project.getPackaging())) {
            this.log.debug((CharSequence)"Not executing on non-WAR project");
            return;
        }
        File warDir = new File(this.outputDirectory, this.project.getBuild().getFinalName());
        if (!warDir.exists() || !warDir.isDirectory()) {
            throw new MojoExecutionException("Invalid WAR build directory: " + warDir);
        }
        this.transformedWarDir = new File(this.outputDirectory, this.baseName + "-" + this.classifier);
        FileUtils.copyDirectoryStructure((File)warDir, (File)this.transformedWarDir);
        super.doExecute();
        File outWar = new File(this.outputDirectory, this.baseName + "-" + this.classifier + ".war");
        MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
        archive.setAddMavenDescriptor(true);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(outWar);
        this.warArchiver.addDirectory(this.transformedWarDir);
        this.warArchiver.setWebxml(new File(this.transformedWarDir, "WEB-INF/web.xml"));
        archiver.createArchive(this.project, archive);
        if (this.attach) {
            this.projectHelper.attachArtifact(this.project, "war", this.classifier, outWar);
        }
    }

    protected void configureRetrotranslator(Retrotranslator retrotranslator) throws Exception {
        retrotranslator.addSrcdir(new File(this.transformedWarDir, "WEB-INF/classes"));
        if (this.jarfileset == null) {
            this.jarfileset = new DirectoryScanner();
            this.jarfileset.setIncludes(new String[]{"*.jar"});
        }
        this.jarfileset.setBasedir(new File(this.transformedWarDir, "WEB-INF/lib"));
        this.jarfileset.scan();
        String[] jarFiles = this.jarfileset.getIncludedFiles();
        for (int i = 0; i < jarFiles.length; ++i) {
            retrotranslator.addSrcjar(new File(this.jarfileset.getBasedir(), jarFiles[i]));
        }
    }
}

