/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.retrotranslator;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.sf.retrotranslator.transformer.MessageLogger;
import net.sf.retrotranslator.transformer.Retrotranslator;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.retrotranslator.RetrotranslatorLogger;

public abstract class RetrotranslateMojoSupport
extends MojoSupport {
    private List classpathElements;
    private List verifyClasspath;
    private boolean stripsign;
    private boolean verbose;
    private boolean verify;
    private boolean lazy;
    private boolean failonwarning;
    private boolean advanced;
    private String embed;
    private String backport;
    private String target;
    private boolean retainapi;
    private boolean retainflags;
    private String srcmask;

    protected void doExecute() throws Exception {
        boolean verified;
        File file;
        String path;
        Iterator iter;
        Retrotranslator retrotranslator = new Retrotranslator();
        retrotranslator.setLogger((MessageLogger)new RetrotranslatorLogger(this.getLog()));
        this.configureRetrotranslator(retrotranslator);
        retrotranslator.setVerbose(this.verbose);
        retrotranslator.setStripsign(this.stripsign);
        retrotranslator.setLazy(this.lazy);
        retrotranslator.setVerify(this.verify);
        retrotranslator.setAdvanced(this.advanced);
        retrotranslator.setEmbed(this.embed);
        retrotranslator.setBackport(this.backport);
        retrotranslator.setRetainapi(this.retainapi);
        retrotranslator.setRetainflags(this.retainflags);
        if (this.target != null) {
            retrotranslator.setTarget(this.target);
        }
        if (this.srcmask != null) {
            retrotranslator.setSrcmask(this.srcmask);
        }
        if (this.classpathElements != null) {
            iter = this.classpathElements.iterator();
            while (iter.hasNext()) {
                path = (String)iter.next();
                file = new File(path);
                retrotranslator.addClasspathElement(file);
            }
        }
        if (this.verify) {
            if (SystemUtils.IS_JAVA_1_4) {
                System.err.println("IS JAVA 1.4");
                retrotranslator.setClassLoader(ClassLoader.getSystemClassLoader());
            } else if (this.verifyClasspath == null) {
                throw new MojoExecutionException("Verify classpath must be specified for non-1.4 JVM's");
            }
            if (this.verifyClasspath != null) {
                if (SystemUtils.IS_JAVA_1_4) {
                    this.log.warn((CharSequence)"Invoking JVM is Java 1.4, extra classpath for verify is unneeded");
                }
                iter = this.verifyClasspath.iterator();
                while (iter.hasNext()) {
                    path = (String)iter.next();
                    if (path == null) {
                        throw new MojoExecutionException("Null element in <verifyClasspath>");
                    }
                    file = new File(path);
                    retrotranslator.addClasspathElement(file);
                }
            }
        }
        if (!(verified = retrotranslator.run()) && this.failonwarning) {
            throw new MojoExecutionException("Verification failed.");
        }
    }

    protected abstract void configureRetrotranslator(Retrotranslator var1) throws Exception;
}

