/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.logging.Log;
import org.apache.xerces.dom.DocumentImpl;
import org.codehaus.mojo.ounce.core.OunceCore;
import org.codehaus.mojo.ounce.core.OunceCoreApplication;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.core.OunceCoreProject;
import org.codehaus.mojo.ounce.core.OunceProjectBean;
import org.codehaus.mojo.ounce.core.XmlWriter;
import org.codehaus.mojo.ounce.utils.Utils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=OunceCore.class, hint="ouncexml")
public class OunceCoreXmlSerializer
implements OunceCore {
    private HashMap<String, Object> m_existingProjectAttributes;

    @Override
    public void createApplication(String baseDir, String theName, String applicationRoot, List theProjects, Map options, Log log) throws OunceCoreException {
        Collections.sort(theProjects);
        log.info((CharSequence)"Writing Application parameters to xml...");
        try {
            Object xmlDoc;
            this.m_existingProjectAttributes = new HashMap();
            Element root = null;
            File pafFile = new File(baseDir, theName + ".paf");
            if (pafFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                log.info((CharSequence)("Reading existing paf: '" + pafFile.getAbsolutePath() + "'..."));
                xmlDoc = builder.parse(pafFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Application")) continue;
                    root = (Element)node;
                    NodeList applicationChildren = node.getChildNodes();
                    for (int j = 0; j < applicationChildren.getLength(); ++j) {
                        Node child = applicationChildren.item(j);
                        String childName = child.getNodeName();
                        if (!childName.equals("Project")) continue;
                        NamedNodeMap attributes = child.getAttributes();
                        String projectPath = attributes.getNamedItem("path").getNodeValue();
                        log.debug((CharSequence)("OunceCoreXmlSerializer: projectpath: " + projectPath));
                        this.m_existingProjectAttributes.put(projectPath, attributes);
                        node.removeChild(child);
                    }
                    log.debug((CharSequence)("OunceCoreXmlSerializer: file path: " + pafFile.getAbsolutePath() + " Root: " + root));
                    this.insertChildProjects((Document)xmlDoc, root, theProjects, pafFile.getAbsolutePath(), log);
                }
                if (root == null) {
                    throw new OunceCoreException("The existing application file '" + pafFile.getAbsolutePath() + "' is not in a valid format and cannot be updated.");
                }
            } else {
                log.info((CharSequence)("Creating new application file: '" + pafFile.getAbsolutePath() + "'..."));
                xmlDoc = new DocumentImpl();
                root = xmlDoc.createElement("Application");
                String name = theName;
                log.info((CharSequence)("Application Name: " + theName));
                root.setAttribute("name", theName);
                xmlDoc.appendChild(root);
                this.insertChildProjects((Document)xmlDoc, root, theProjects, pafFile.getAbsolutePath(), log);
            }
            log.info((CharSequence)"Writing XML ....");
            pafFile.getParentFile().mkdirs();
            XmlWriter writer = new XmlWriter(true);
            writer.setWriteEmptyValues(false);
            writer.setDefaultToAttributesOnSameLine(true);
            writer.saveXmlFile(pafFile.getAbsolutePath(), (Document)xmlDoc);
            log.info((CharSequence)"Done.");
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    private void insertChildProjects(Document xmlDoc, Element root, List theProjects, String applicationFile, Log log) throws IOException {
        Collections.sort(theProjects, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                OunceProjectBean project1 = (OunceProjectBean)arg0;
                OunceProjectBean project2 = (OunceProjectBean)arg1;
                String projectPath1 = project1.getPath() + File.separator + project1.name + ".ppf";
                String projectPath2 = project2.getPath() + File.separator + project2.name + ".ppf";
                return projectPath2.compareTo(projectPath1);
            }
        });
        for (int i = 0; i < theProjects.size(); ++i) {
            NodeList childNodes;
            boolean hasChildren;
            OunceProjectBean projectBean = (OunceProjectBean)theProjects.get(i);
            String projectPath = new File(projectBean.getPath(), projectBean.getName() + ".ppf").getCanonicalPath();
            log.debug((CharSequence)("OunceCoreXmlSerializer: Project Path: " + projectPath));
            log.debug((CharSequence)("OunceCoreXmlSerializer: Name: " + projectBean.getName()));
            Element project = xmlDoc.createElementNS(null, "Project");
            NamedNodeMap existingAttribs = (NamedNodeMap)this.m_existingProjectAttributes.get(projectPath);
            if (existingAttribs != null) {
                existingAttribs.removeNamedItem("path");
                existingAttribs.removeNamedItem("language_type");
            }
            projectPath = Utils.makeRelative(projectPath, new File(applicationFile).getParent());
            project.setAttributeNS(null, "path", projectPath);
            project.setAttributeNS(null, "language_type", "2");
            if (existingAttribs != null) {
                for (int j = 0; j < existingAttribs.getLength(); ++j) {
                    Node node = existingAttribs.item(j);
                    String name = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    project.setAttributeNS(null, name, nodeValue);
                }
            }
            boolean bl = hasChildren = (childNodes = root.getChildNodes()).getLength() > 0;
            if (hasChildren) {
                Node child = childNodes.item(0);
                root.insertBefore(project, child);
                continue;
            }
            root.appendChild(project);
        }
    }

    @Override
    public void createProject(String baseDir, String theName, String jspCompilerInfoName, String jspCompilerType, String projectRoot, List theSourceRoots, String theWebRoot, String theClassPath, String theJdkName, String compilerOptions, String packaging, Map options, boolean forceWeb, boolean analyzeStrutsFramework, boolean importStrutsValidation, String projectDir, Log log) throws OunceCoreException {
        Properties projectAttrs = new Properties();
        projectAttrs.setProperty("name", theName);
        projectAttrs.setProperty("file_extension_set_name", "java");
        projectAttrs.setProperty("language_type", "2");
        projectAttrs.setProperty("default_configuration_name", "Configuration 1");
        if (StringUtils.isNotEmpty((String)jspCompilerInfoName)) {
            projectAttrs.setProperty("jsp_compiler_info_name", jspCompilerInfoName);
        }
        if (StringUtils.isNotEmpty((String)jspCompilerType)) {
            projectAttrs.setProperty("jsp_compiler_type", jspCompilerType);
        }
        if (!StringUtils.isEmpty((String)theWebRoot) && (forceWeb || !StringUtils.isEmpty((String)packaging) && packaging.equals("war"))) {
            projectAttrs.setProperty("web_context_root_path", theWebRoot.trim());
        } else {
            theWebRoot = null;
        }
        if (!StringUtils.isEmpty((String)compilerOptions)) {
            projectAttrs.setProperty("compiler_options", compilerOptions);
        }
        if (analyzeStrutsFramework) {
            projectAttrs.setProperty("analyze_struts_framework", "true");
        }
        if (importStrutsValidation) {
            projectAttrs.setProperty("import_struts_validation", "true");
        }
        try {
            Object xmlDoc;
            HashMap<String, NamedNodeMap> existingConfigurationAttribs = new HashMap<String, NamedNodeMap>();
            HashMap<String, NamedNodeMap> existingSourceAttribs = new HashMap<String, NamedNodeMap>();
            HashMap<String, String> existingProperties = new HashMap<String, String>();
            ArrayList<Node> excludedSources = new ArrayList<Node>();
            Element root = null;
            File ppfFile = new File(projectDir, theName + ".ppf");
            if (ppfFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                log.info((CharSequence)("Reading ppf: '" + ppfFile.getAbsolutePath() + "'..."));
                xmlDoc = builder.parse(ppfFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Project")) continue;
                    root = (Element)node;
                    NodeList projectChildren = node.getChildNodes();
                    for (int j = 0; j < projectChildren.getLength(); ++j) {
                        Node child = projectChildren.item(j);
                        String childName = child.getNodeName();
                        NamedNodeMap attributes = child.getAttributes();
                        if (childName.equals("Configuration")) {
                            String configurationName = attributes.getNamedItem("name").getNodeValue();
                            existingConfigurationAttribs.put(configurationName, attributes);
                            node.removeChild(child);
                            continue;
                        }
                        if (childName.equals("Source")) {
                            String sourcePath = attributes.getNamedItem("path").getNodeValue();
                            log.info((CharSequence)("Source Path: " + sourcePath));
                            String excludedStr = attributes.getNamedItem("exclude").getNodeValue();
                            if (excludedStr.equals("true")) {
                                excludedSources.add(child);
                            }
                            existingSourceAttribs.put(sourcePath, attributes);
                            node.removeChild(child);
                            continue;
                        }
                        if (!childName.equals("Properties")) continue;
                        NodeList properties = child.getChildNodes();
                        for (int k = 0; k < properties.getLength(); ++k) {
                            Node property = properties.item(k);
                            if (!property.getNodeName().equals("Property")) continue;
                            Node propertyName = property.getAttributes().getNamedItem("name");
                            Node propertyValue = property.getAttributes().getNamedItem("value");
                            if (propertyName == null || propertyValue == null) continue;
                            existingProperties.put(propertyName.getNodeValue(), propertyValue.getNodeValue());
                        }
                        node.removeChild(child);
                    }
                }
                if (root == null) {
                    throw new OunceCoreException("The existing project file '" + ppfFile.getAbsolutePath() + "' is not in a valid format and cannot be updated.");
                }
            } else {
                xmlDoc = new DocumentImpl();
                root = xmlDoc.createElement("Project");
                xmlDoc.appendChild(root);
            }
            Enumeration<?> propertyNames = projectAttrs.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object propertyNameObject = propertyNames.nextElement();
                String name = (String)propertyNameObject;
                String value = projectAttrs.getProperty(name);
                root.setAttribute(name, value);
            }
            this.insertSources((Document)xmlDoc, root, baseDir, theSourceRoots, theWebRoot, existingSourceAttribs, excludedSources);
            this.insertConfigurations((Document)xmlDoc, root, theClassPath, theJdkName, existingConfigurationAttribs);
            existingProperties.putAll(options);
            this.insertProperties((Document)xmlDoc, root, existingProperties);
            log.info((CharSequence)"Writing ppf file...");
            ppfFile.getParentFile().mkdirs();
            XmlWriter writer = new XmlWriter(true);
            writer.setWriteEmptyValues(false);
            writer.setDefaultToAttributesOnSameLine(true);
            writer.saveXmlFile(ppfFile.getAbsolutePath(), (Document)xmlDoc);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    private void insertConfigurations(Document xmlDoc, Element root, String theClassPath, String theJdkName, HashMap existingConfigurationAttribs) {
        NodeList childNodes;
        boolean hasChildren;
        Properties configAttributes = new Properties();
        String configurationName = "Configuration 1";
        configAttributes.setProperty("name", configurationName);
        configAttributes.setProperty("class_path", theClassPath);
        if (!StringUtils.isEmpty((String)theJdkName)) {
            configAttributes.setProperty("jdk_name", theJdkName.trim());
        }
        Element configuration = xmlDoc.createElementNS(null, "Configuration");
        NamedNodeMap existingConfigAttribs = (NamedNodeMap)existingConfigurationAttribs.get(configurationName);
        Enumeration<?> propertyNames = configAttributes.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object propertyNameObject = propertyNames.nextElement();
            String name = (String)propertyNameObject;
            String value = configAttributes.getProperty(name);
            configuration.setAttributeNS(null, name, value);
            if (existingConfigAttribs == null || existingConfigAttribs.getNamedItem(name) == null) continue;
            existingConfigAttribs.removeNamedItem(name);
        }
        if (existingConfigAttribs != null) {
            for (int j = 0; j < existingConfigAttribs.getLength(); ++j) {
                Node node = existingConfigAttribs.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                configuration.setAttributeNS(null, name, value);
            }
        }
        boolean bl = hasChildren = (childNodes = root.getChildNodes()).getLength() > 0;
        if (hasChildren) {
            Node child = childNodes.item(0);
            root.insertBefore(configuration, child);
        } else {
            root.appendChild(configuration);
        }
    }

    private void insertSources(Document xmlDoc, Element root, String baseDir, List theSourceRoots, String webRoot, HashMap existingSourceAttribs, ArrayList excludedSources) {
        int i;
        Collections.sort(theSourceRoots, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String root1 = (String)arg0;
                String root2 = (String)arg1;
                return root2.compareTo(root1);
            }
        });
        for (i = 0; i < theSourceRoots.size(); ++i) {
            String sourceRoot = (String)theSourceRoots.get(i);
            if (this.pathAlreadyInNodeList(excludedSources, sourceRoot)) continue;
            this.addSourceElement(xmlDoc, root, sourceRoot, "false", false, existingSourceAttribs);
        }
        for (i = 0; i < excludedSources.size(); ++i) {
            boolean hasChildren;
            Node node = (Node)excludedSources.get(i);
            NamedNodeMap attributes = node.getAttributes();
            String path = attributes.getNamedItem("path").getNodeValue();
            if (!new File(baseDir + File.separator + path).exists()) continue;
            NodeList childNodes = root.getChildNodes();
            boolean bl = hasChildren = childNodes.getLength() > 0;
            if (hasChildren) {
                Node child = childNodes.item(0);
                root.insertBefore(node, child);
                continue;
            }
            root.appendChild(node);
        }
        ArrayList srcRoots = new ArrayList();
        srcRoots.addAll(theSourceRoots);
        if (webRoot == null || webRoot.isEmpty()) {
            return;
        }
        if (webRoot != null && !this.pathAlreadyInNodeList(theSourceRoots, webRoot, root)) {
            this.addSourceElement(xmlDoc, root, webRoot, "true", true, existingSourceAttribs);
        } else {
            NodeList nl = root.getChildNodes();
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node node = nl.item(i2);
                NamedNodeMap nnm = node.getAttributes();
                for (int x = 0; x < nnm.getLength(); ++x) {
                    String pathAttr = nnm.getNamedItem("path").getNodeValue();
                    String webAttr = nnm.getNamedItem("web").getNodeValue();
                    if (!webRoot.equals(pathAttr) || !webAttr.equals("false")) continue;
                    nnm.getNamedItem("web").setNodeValue("true");
                }
            }
        }
    }

    private void insertProperties(Document xmlDoc, Element root, Map<String, String> properties) {
        Element propertiesElement = xmlDoc.createElementNS(null, "Properties");
        for (String key : properties.keySet()) {
            Element propertyElement = xmlDoc.createElementNS(null, "Property");
            propertyElement.setAttribute("name", key);
            propertyElement.setAttribute("value", properties.get(key));
            propertiesElement.appendChild(propertyElement);
        }
        root.appendChild(propertiesElement);
    }

    private void addSourceElement(Document xmlDoc, Element root, String sourceRoot, String defaultWeb, boolean forceWeb, HashMap existingSourceAttribs) {
        NodeList childNodes;
        boolean hasChildren;
        Element source = xmlDoc.createElementNS(null, "Source");
        source.setAttributeNS(null, "path", sourceRoot);
        NamedNodeMap existingAttribs = (NamedNodeMap)existingSourceAttribs.get(sourceRoot);
        if (existingAttribs != null) {
            existingAttribs.removeNamedItem("path");
        }
        if (existingAttribs == null || existingAttribs.getNamedItem("exclude") == null) {
            source.setAttributeNS(null, "exclude", "false");
        }
        if (forceWeb) {
            if (existingAttribs != null) {
                existingAttribs.removeNamedItem("web");
            }
            source.setAttributeNS(null, "web", defaultWeb);
        } else if (existingAttribs == null || existingAttribs.getNamedItem("web") == null) {
            source.setAttributeNS(null, "web", defaultWeb);
        }
        if (existingAttribs != null) {
            for (int j = 0; j < existingAttribs.getLength(); ++j) {
                Node node = existingAttribs.item(j);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                source.setAttributeNS(null, name, value);
            }
        }
        boolean bl = hasChildren = (childNodes = root.getChildNodes()).getLength() > 0;
        if (hasChildren) {
            Node child = childNodes.item(0);
            root.insertBefore(source, child);
        } else {
            root.appendChild(source);
        }
    }

    private boolean pathAlreadyInNodeList(ArrayList list, String relPath) {
        for (int i = 0; i < list.size(); ++i) {
            Node node = (Node)list.get(i);
            NamedNodeMap attributes = node.getAttributes();
            String path = attributes.getNamedItem("path").getNodeValue();
            if (!relPath.startsWith("./")) {
                relPath = "./" + relPath;
            }
            if (!relPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private boolean pathAlreadyInNodeList(List list, String path, Element root) {
        int counter = 0;
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            ++counter;
            Node node = nl.item(i);
            NamedNodeMap nnm = node.getAttributes();
            if (nnm == null) break;
            for (int x = 0; x < nnm.getLength(); ++x) {
                String pathAttr = nnm.getNamedItem("path").getNodeValue();
                String webAttr = nnm.getNamedItem("web").getNodeValue();
                if (!path.equals(pathAttr) || !webAttr.equals("false")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public OunceCoreApplication readApplication(String path, Log log) throws OunceCoreException {
        block6: {
            try {
                File pafFile = new File(path);
                if (pafFile.exists()) {
                    String parentDir = pafFile.getParent();
                    String applicationFile = "File";
                    String applicationName = "name";
                    ArrayList<OunceCoreProject> projects = new ArrayList<OunceCoreProject>();
                    HashMap options = new HashMap();
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    if (log != null) {
                        log.info((CharSequence)("Reading paf: '" + path + "'..."));
                    }
                    Document xmlDoc = builder.parse(pafFile);
                    NodeList nodes = xmlDoc.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        String name = node.getNodeName();
                        if (!name.equals("Application")) continue;
                        NamedNodeMap applicationAttribs = node.getAttributes();
                        applicationName = applicationAttribs.getNamedItem("name").getNodeValue();
                        NodeList applicationChildren = node.getChildNodes();
                        for (int j = 0; j < applicationChildren.getLength(); ++j) {
                            Node child = applicationChildren.item(j);
                            String childName = child.getNodeName();
                            if (!childName.equals("Project")) continue;
                            String projectPath = new File(parentDir, child.getAttributes().getNamedItem("path").getNodeValue()).getAbsolutePath();
                            OunceCoreProject project = this.readProject(new File(projectPath).getAbsolutePath(), log);
                            projects.add(project);
                        }
                    }
                    OunceCoreApplication application = new OunceCoreApplication(applicationName, applicationFile, projects, options);
                    return application;
                }
            }
            catch (Exception ex) {
                if (log == null) break block6;
                log.error((Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public OunceCoreProject readProject(String path, Log log) throws OunceCoreException {
        try {
            File ppfFile = new File(path);
            if (ppfFile.exists()) {
                String projectName = null;
                String jdkName = null;
                String classPath = null;
                String webRoot = null;
                String optionsStr = null;
                ArrayList<String> sourceRoots = new ArrayList<String>();
                HashMap<String, String> options = new HashMap<String, String>();
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (log != null) {
                    log.info((CharSequence)("Reading ppf: '" + path + "'..."));
                }
                Document xmlDoc = builder.parse(ppfFile);
                NodeList nodes = xmlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String name = node.getNodeName();
                    if (!name.equals("Project")) continue;
                    NamedNodeMap projectAttribs = node.getAttributes();
                    for (int j = 0; j < projectAttribs.getLength(); ++j) {
                        Node attribNode = projectAttribs.item(j);
                        String nodeName = attribNode.getNodeName();
                        String nodeValue = attribNode.getNodeValue();
                        if (nodeName.equals("name") || nodeName.equals("web_context_root_path")) continue;
                        options.put(nodeName, nodeValue);
                    }
                    if (projectAttribs.getNamedItem("web_context_root_path") != null) {
                        webRoot = projectAttribs.getNamedItem("web_context_root_path").getNodeValue();
                    }
                    projectName = projectAttribs.getNamedItem("name").getNodeValue();
                    NodeList projectChildren = node.getChildNodes();
                    for (int j = 0; j < projectChildren.getLength(); ++j) {
                        Node child = projectChildren.item(j);
                        String childName = child.getNodeName();
                        NamedNodeMap attribs = child.getAttributes();
                        if (childName.equals("Configuration")) {
                            if (attribs.getNamedItem("jdk_name") != null) {
                                jdkName = attribs.getNamedItem("jdk_name").getNodeValue();
                            }
                            if (attribs.getNamedItem("class_path") != null) {
                                classPath = attribs.getNamedItem("class_path").getNodeValue();
                            }
                            if (attribs.getNamedItem("compiler_options") == null) continue;
                            optionsStr = attribs.getNamedItem("compiler_options").getNodeValue();
                            continue;
                        }
                        if (!childName.equals("Source")) continue;
                        String sourcePath = attribs.getNamedItem("path").getNodeValue();
                        String webStr = attribs.getNamedItem("web").getNodeValue();
                        if (webStr != null && (webStr == null || webStr.equals("true"))) continue;
                        sourceRoots.add(sourcePath);
                    }
                }
                String packaging = null;
                if (webRoot != null) {
                    packaging = "war";
                }
                OunceCoreProject project = new OunceCoreProject(projectName, ppfFile.getParent(), sourceRoots, webRoot, classPath, jdkName, packaging, optionsStr, options);
                log.debug((CharSequence)("OunceCoreXmlSerializer: projectRoot " + ppfFile.getParent()));
                return project;
            }
            throw new OunceCoreException("The file '" + ppfFile.getPath() + "' does not exist.");
        }
        catch (Exception ex) {
            if (log != null) {
                log.error((Throwable)ex);
            }
            return null;
        }
    }

    @Override
    public void scan(String applicationFile, String assessmentName, String assessmentOutput, String scanconfig, String caller, String reportType, String reportOutputType, String reportOutputLocation, boolean includeHowToFix, boolean publish, Map ounceOptions, String installDir, boolean wait, boolean includeTraceDefinitive, boolean includeTraceSuspect, boolean includeTraceCoverage, String appserver_type, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        log.debug((CharSequence)("ounceauto command: " + command));
        String existingAssessment = null;
        int includeSrcBefore = -1;
        int includeSrcAfter = -1;
        if (ounceOptions != null) {
            if (ounceOptions.get("existingAssessmentFile") != null) {
                existingAssessment = (String)ounceOptions.get("existingAssessmentFile");
            }
            if (ounceOptions.get("includeSrcBefore") != null) {
                includeSrcBefore = (Integer)ounceOptions.get("includeSrcBefore");
            }
            if (ounceOptions.get("includeSrcAfter") != null) {
                includeSrcAfter = (Integer)ounceOptions.get("includeSrcAfter");
            }
        }
        try {
            if (existingAssessment == null) {
                command = command + " scanapplication";
                if (!StringUtils.isEmpty((String)applicationFile)) {
                    command = command + " -application_file \"" + applicationFile + "\"";
                }
                if (!StringUtils.isEmpty((String)assessmentName)) {
                    command = command + " -name \"" + assessmentName + "\"";
                }
                if (!StringUtils.isEmpty((String)assessmentOutput)) {
                    command = command + " -save \"" + assessmentOutput + "\"";
                }
                if (!StringUtils.isEmpty((String)scanconfig)) {
                    byte[] b = scanconfig.getBytes("UTF-8");
                    String convertedscanconfig = new String(b, "US-ASCII");
                    command = command + " -scanconfig \"" + convertedscanconfig + "\"";
                }
                if (!StringUtils.isEmpty((String)appserver_type)) {
                    command = command + " -appserver_type \"" + appserver_type + "\"";
                }
                if (!StringUtils.isEmpty((String)reportType)) {
                    command = command + " -report \"" + reportType + "\" \"" + reportOutputType + "\" \"" + reportOutputLocation + "\"";
                    if (includeHowToFix) {
                        command = command + " -includeHowToFix";
                    }
                    if (includeTraceDefinitive) {
                        command = command + " -includeTraceDefinitive";
                    }
                    if (includeTraceSuspect) {
                        command = command + " -includeTraceSuspect";
                    }
                    if (includeTraceCoverage) {
                        command = command + " -includeTraceCoverage";
                    }
                }
                if (publish) {
                    command = command + " -publish";
                }
            } else {
                command = command + " generatereport -assessment \"" + existingAssessment + "\"";
                if (!StringUtils.isEmpty((String)reportType)) {
                    command = command + " -type \"" + reportType + "\" -output \"" + reportOutputType + "\" -file \"" + reportOutputLocation + "\"";
                    if (includeHowToFix) {
                        command = command + " -includeHowToFix";
                    }
                    if (includeTraceDefinitive) {
                        command = command + " -includeTraceDefinitive";
                    }
                    if (includeTraceSuspect) {
                        command = command + " -includeTraceSuspect";
                    }
                    if (includeTraceCoverage) {
                        command = command + " -includeTraceCoverage";
                    }
                }
            }
            if (!StringUtils.isEmpty((String)caller)) {
                command = command + " -caller \"" + caller + "\"";
            }
            if (includeSrcBefore != -1) {
                command = command + " -includeSrcBefore " + includeSrcBefore;
            }
            if (includeSrcAfter != -1) {
                command = command + " -includeSrcAfter " + includeSrcAfter;
            }
            log.info((CharSequence)command);
            int requestId = this.executeCommand(command, log);
            log.info((CharSequence)("requestId: " + requestId));
            if (wait) {
                command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
                command = command + " wait -requestid " + requestId;
                log.info((CharSequence)command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception ex) {
            throw new OunceCoreException(ex);
        }
    }

    @Override
    public void createPathVariables(Map pathVariableMap, String installDir, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        try {
            command = command + " setvars";
            if (pathVariableMap != null) {
                Set keys = pathVariableMap.keySet();
                for (String key : keys) {
                    String value = (String)pathVariableMap.get(key);
                    command = command + " -" + key + " " + value;
                }
                log.info((CharSequence)command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int executeCommand(String command, Log log) throws IOException, InterruptedException {
        String line;
        String OS = "Windows";
        String opSys = System.getProperty("os.name");
        Process p = null;
        log.info((CharSequence)("Operating System: " + opSys));
        if (!opSys.startsWith("Windows")) {
            FileWriter fw;
            File cli;
            if (opSys.equals("Mac OS X")) {
                cli = new File("/Users/Shared/AppScanSource/logs/maven_ounceauto.sh");
                cli.setExecutable(true);
                fw = new FileWriter(cli);
                fw.append(command);
                fw.close();
                p = Runtime.getRuntime().exec(cli.getAbsolutePath());
            }
            if (opSys.equals("Linux")) {
                cli = new File("/var/opt/hcl/appscansource").exists() ? new File("/var/opt/hcl/appscansource/logs/maven_ounceauto.sh") : new File("/var/opt/ibm/appscansource/logs/maven_ounceauto.sh");
                cli.setExecutable(true);
                fw = new FileWriter(cli);
                fw.append(command);
                fw.close();
                p = Runtime.getRuntime().exec(cli.getAbsolutePath());
            }
        } else {
            p = Runtime.getRuntime().exec(command);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            if (log != null) {
                log.info((CharSequence)("ounceauto: " + line));
                continue;
            }
            log.info((CharSequence)("ounceauto: " + line));
        }
        input.close();
        return p.waitFor();
    }

    @Override
    public void publishASE(String aseApplication, String nameToPublish, String assessmentFile, String caller, String folderID, String installDir, boolean wait, Log log) throws OunceCoreException {
        String command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
        try {
            command = command + " PublishAssessmentASE";
            if (!StringUtils.isEmpty((String)aseApplication)) {
                command = command + String.format(" -aseapplication \"%s\"", aseApplication);
            }
            if (!StringUtils.isEmpty((String)nameToPublish)) {
                command = command + String.format(" -name \"%s\"", nameToPublish);
            }
            if (!StringUtils.isEmpty((String)assessmentFile)) {
                command = command + String.format(" -file \"%s\"", assessmentFile);
            }
            if (!StringUtils.isEmpty((String)caller)) {
                command = command + " -caller " + caller;
            }
            if (!StringUtils.isEmpty((String)folderID)) {
                command = command + " -folderid " + folderID;
            }
            log.info((CharSequence)command);
            int requestId = this.executeCommand(command, log);
            log.info((CharSequence)("requestId: " + requestId));
            if (wait) {
                command = installDir == null ? "ounceauto" : installDir + File.separator + "bin" + File.separator + "ounceauto";
                command = command + " wait -requestid " + requestId;
                log.info((CharSequence)command);
                this.executeCommand(command, log);
            }
        }
        catch (Exception ex) {
            throw new OunceCoreException(ex);
        }
    }
}

