/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.openjpa;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.lib.util.Options;
import org.codehaus.mojo.openjpa.AbstractOpenJpaMojo;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractOpenJpaEnhancerMojo
extends AbstractOpenJpaMojo {
    protected boolean addDefaultConstructor;
    private static final String OPTION_ADD_DEFAULT_CONSTRUCTOR = "addDefaultConstructor";
    protected boolean enforcePropertyRestrictions;
    private static final String OPTION_ENFORCE_PROPERTY_RESTRICTION = "enforcePropertyRestrictions";
    protected boolean tmpClassLoader;
    private static final String OPTION_USE_TEMP_CLASSLOADER = "tcl";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        if (!this.getEntityClasses().exists()) {
            FileUtils.mkdir((String)this.getEntityClasses().getAbsolutePath());
        }
        List entities = this.findEntityClassFiles();
        this.enhance(entities);
    }

    protected Options getOptions() {
        Options opts = this.createOptions();
        opts.put((Object)OPTION_ADD_DEFAULT_CONSTRUCTOR, (Object)Boolean.toString(this.addDefaultConstructor));
        opts.put((Object)OPTION_ENFORCE_PROPERTY_RESTRICTION, (Object)Boolean.toString(this.enforcePropertyRestrictions));
        opts.put((Object)OPTION_USE_TEMP_CLASSLOADER, (Object)Boolean.toString(this.tmpClassLoader));
        return opts;
    }

    private void enhance(List files) throws MojoExecutionException {
        Options opts = this.getOptions();
        String[] args = this.getFilePaths(files);
        boolean ok = false;
        if (!this.tmpClassLoader) {
            this.extendRealmClasspath();
        }
        if (!(ok = PCEnhancer.run((String[])args, (Options)opts))) {
            throw new MojoExecutionException("The OpenJPA Enhancer tool detected an error!");
        }
    }
}

