/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nsis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="generate-headerfile", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class GenerateHeaderfileMojo
extends AbstractMojo {
    @Parameter(property="nsis.headerfile", defaultValue="${project.build.directory}/project.nsh", required=true)
    private File headerFile;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MessageWriter writer;
        FileWriter filewriter;
        block7: {
            filewriter = null;
            writer = null;
            try {
                File parentDir = this.headerFile.getParentFile();
                if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                    throw new MojoFailureException("Unable to create parent directory " + parentDir.getAbsolutePath() + " for header file " + this.headerFile.getAbsolutePath());
                }
                filewriter = new FileWriter(this.headerFile);
                writer = new MessageWriter(filewriter);
                writer.println("; Template for project details");
                writer.println("; Generated by {0} from pom.xml version {1}", System.getProperty("user.name"), this.project.getVersion());
                writer.println("; on date {0,date}, time {0,time}", new Date());
                writer.println("");
                writer.println("!define PROJECT_BASEDIR \"{0}\"", this.project.getBasedir());
                writer.println("!define PROJECT_BUILD_DIR \"{0}\"", this.project.getBuild().getDirectory());
                writer.println("!define PROJECT_FINAL_NAME \"{0}\"", this.project.getBuild().getFinalName());
                writer.println("!define PROJECT_GROUP_ID \"{0}\"", this.project.getGroupId());
                writer.println("!define PROJECT_ARTIFACT_ID \"{0}\"", this.project.getArtifactId());
                writer.println("!define PROJECT_NAME \"{0}\"", this.project.getName());
                writer.println("!define PROJECT_VERSION \"{0}\"", this.project.getVersion());
                if (StringUtils.isNotEmpty((String)this.project.getUrl())) {
                    writer.println("!define PROJECT_URL \"{0}\"", this.project.getUrl());
                }
                if (this.project.getOrganization() != null) {
                    writer.println("!define PROJECT_ORGANIZATION_NAME \"{0}\"", this.project.getOrganization().getName());
                    writer.println("!define PROJECT_ORGANIZATION_URL \"{0}\"", this.project.getOrganization().getUrl());
                    writer.println("!define PROJECT_REG_KEY \"SOFTWARE\\{0}\\{1}\\{2}\"", new Object[]{this.project.getOrganization().getName(), this.project.getName(), this.project.getVersion()});
                    writer.println("!define PROJECT_REG_UNINSTALL_KEY \"Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{0} {1}\"", this.project.getName(), this.project.getVersion());
                    writer.println("!define PROJECT_STARTMENU_FOLDER \"{0}\\{1}\\{2} {3}\"", new Object[]{"${SMPROGRAMS}", this.project.getOrganization().getName(), this.project.getName(), this.project.getVersion()});
                    break block7;
                }
                writer.println("; The project organization section is missing from your pom.xml");
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Unable to generate project script " + this.headerFile.getAbsolutePath(), (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    IOUtil.close(filewriter);
                    throw throwable;
                }
            }
        }
        IOUtil.close((Writer)writer);
        IOUtil.close((Writer)filewriter);
    }

    class MessageWriter
    extends PrintWriter {
        public MessageWriter(Writer out) {
            super(out);
        }

        public void println(String pattern, Object[] arguments) {
            this.println(MessageFormat.format(pattern, arguments));
        }

        public void println(String pattern, Object arg1) {
            this.println(pattern, new Object[]{arg1});
        }

        public void println(String pattern, Object arg1, Object arg2) {
            this.println(pattern, new Object[]{arg1, arg2});
        }
    }
}

