/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.bcc;

import java.io.File;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.AbstractLinker;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.cli.Commandline;

@Component(role=Linker.class, hint="tlib", instantiationStrategy="per-lookup")
public class TLibLinker
extends AbstractLinker {
    public static final String EXECUTABLE = "tlib";

    protected Commandline createLinkerCommandLine(List<File> objectFiles, LinkerConfiguration config) throws NativeBuildException {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        String executable = EXECUTABLE;
        if (config.getExecutable() != null && config.getExecutable().trim().length() != 0) {
            executable = config.getExecutable();
        }
        cl.createArg().setValue(executable);
        cl.createArg().setValue("\"" + config.getOutputFile() + "\"");
        for (int i = 0; i < config.getStartOptions().length; ++i) {
            cl.createArg().setValue(config.getStartOptions()[i]);
        }
        for (File objFile : objectFiles) {
            cl.createArg().setValue("+\"" + objFile.getPath() + "\"");
        }
        return cl;
    }
}

