/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.native2ascii.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.native2ascii.Native2Ascii;
import org.codehaus.mojo.native2ascii.mojo.AbstractNative2AsciiMojo;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="inplace", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class Native2AsciiInplaceMojo
extends AbstractNative2AsciiMojo {
    @Parameter(required=true, defaultValue="${native2ascii.dir}")
    protected File dir;

    @Override
    protected File getSourceDirectory() {
        return this.dir;
    }

    @Override
    public void executeTransformation(Iterator<File> files) throws MojoExecutionException {
        while (files.hasNext()) {
            File file = files.next();
            this.getLog().info((CharSequence)("Processing " + file.getAbsolutePath()));
            try {
                File tempFile = File.createTempFile(file.getName(), "native2ascii");
                new Native2Ascii(this.getLog()).nativeToAscii(file, tempFile, this.encoding);
                FileUtils.rename((File)tempFile, (File)file);
                this.getLog().info((CharSequence)("File converted successfuly: " + file.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to convert " + file.getAbsolutePath(), (Exception)e);
            }
        }
    }
}

