/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.compiler.MessageCompiler;
import org.codehaus.mojo.natives.compiler.MessageCompilerConfiguration;
import org.codehaus.mojo.natives.manager.MessageCompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.mojo.natives.plugin.NativeMojoUtils;

@Mojo(name="compile-message", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class NativeMessageCompileMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="msvc", required=true)
    private String provider;
    @Parameter
    private String messageCompilerExecutable;
    @Parameter
    private List messageCompilerOptions;
    @Parameter(required=true)
    protected File[] messageFiles;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File messageCompilerOutputDirectory;
    @Component
    private MessageCompilerManager manager;

    public void execute() throws MojoExecutionException {
        if (!this.messageCompilerOutputDirectory.exists()) {
            this.messageCompilerOutputDirectory.mkdirs();
        }
        MessageCompiler compiler = this.getMessageCompiler();
        MessageCompilerConfiguration config = new MessageCompilerConfiguration();
        config.setExecutable(this.messageCompilerExecutable);
        config.setWorkingDirectory(this.workingDirectory);
        config.setOutputDirectory(this.messageCompilerOutputDirectory);
        config.setOptions(NativeMojoUtils.trimParams(this.messageCompilerOptions));
        config.setEnvFactory(this.getEnvFactory());
        try {
            compiler.compile(config, this.messageFiles);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.messageCompilerOutputDirectory.getAbsolutePath());
    }

    private MessageCompiler getMessageCompiler() throws MojoExecutionException {
        MessageCompiler mc;
        try {
            mc = this.manager.getMessageCompiler(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return mc;
    }
}

