/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.manager.EnvFactoryManager;
import org.codehaus.mojo.natives.plugin.NativeMojoUtils;

public abstract class AbstractNativeMojo
extends AbstractMojo {
    public static final String LINKER_INPUT_LIST_NAME = "NativeLinkerInputListName";
    public static final String LINKER_OUTPUT_PATH = "NativeLinkerOutputPath";
    public static final String INCZIP_FOUND = "IncZipFound";
    public static final String INCZIP_TYPE = "inczip";
    protected static final List EMPTY_FILE_LIST = new ArrayList();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}", required=true)
    protected File workingDirectory;
    @Parameter
    private String envFactoryName;
    @Component
    protected EnvFactoryManager envFactoryManager;
    @Parameter(defaultValue="${project.build.directory}/native/include")
    protected File dependencyIncludeDirectory;
    private EnvFactory envFactory = null;

    protected static String[] removeEmptyOptions(List args) {
        return NativeMojoUtils.trimParams(args);
    }

    protected List getAllCompilersOutputFileList() {
        ArrayList list = (ArrayList)this.getPluginContext().get(LINKER_INPUT_LIST_NAME);
        if (list == null) {
            list = new ArrayList();
            this.getPluginContext().put(LINKER_INPUT_LIST_NAME, list);
        }
        return list;
    }

    protected void saveCompilerOutputFilePaths(List filePaths) throws MojoExecutionException {
        List allCompilerOutputFileList = this.getAllCompilersOutputFileList();
        for (int i = 0; i < filePaths.size(); ++i) {
            File file = (File)filePaths.get(i);
            allCompilerOutputFileList.add(file);
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected EnvFactory getEnvFactory() throws MojoExecutionException {
        if (this.envFactory == null && this.envFactoryName != null) {
            try {
                this.envFactory = this.envFactoryManager.getEnvFactory(this.envFactoryName);
            }
            catch (NativeBuildException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.envFactory;
    }
}

