/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.compiler.ResourceCompiler;
import org.codehaus.mojo.natives.compiler.ResourceCompilerConfiguration;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.manager.ResourceCompilerManager;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.mojo.natives.plugin.NativeMojoUtils;
import org.codehaus.plexus.util.FileUtils;

public class NativeResourceCompileMojo
extends AbstractNativeMojo {
    private String provider;
    private String resourceCompilerExecutable;
    private List resourceCompilerOptions;
    private NativeSources[] sources;
    private ResourceCompilerManager manager;

    public void execute() throws MojoExecutionException {
        List resourceOutputFiles;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        ResourceCompiler compiler = this.getResourceCompiler();
        FileUtils.mkdir((String)this.project.getBuild().getDirectory());
        ResourceCompilerConfiguration config = new ResourceCompilerConfiguration();
        config.setExecutable(this.resourceCompilerExecutable);
        config.setWorkingDirectory(this.workingDirectory);
        config.setOptions(NativeMojoUtils.trimParams(this.resourceCompilerOptions));
        config.setOutputDirectory(this.outputDirectory);
        config.setEnvFactoryName(this.envFactoryName);
        try {
            resourceOutputFiles = compiler.compile(config, this.sources);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.saveCompilerOutputFilePaths(resourceOutputFiles);
    }

    private ResourceCompiler getResourceCompiler() throws MojoExecutionException {
        ResourceCompiler rc;
        try {
            rc = this.manager.getResourceCompiler(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return rc;
    }
}

