/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.compiler.MessageCompiler;
import org.codehaus.mojo.natives.compiler.MessageCompilerConfiguration;
import org.codehaus.mojo.natives.manager.MessageCompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.mojo.natives.plugin.NativeMojoUtils;

public class NativeMessageCompileMojo
extends AbstractNativeMojo {
    private String provider;
    private String messageCompilerExecutable;
    private List messageCompilerOptions;
    protected File[] messageFiles;
    private MessageCompilerManager manager;
    protected String envFactoryName;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        MessageCompiler compiler = this.getMessageCompiler();
        MessageCompilerConfiguration config = new MessageCompilerConfiguration();
        config.setExecutable(this.messageCompilerExecutable);
        config.setWorkingDirectory(this.workingDirectory);
        config.setOutputDirectory(this.outputDirectory);
        config.setOptions(NativeMojoUtils.trimParams(this.messageCompilerOptions));
        config.setEnvFactoryName(this.envFactoryName);
        try {
            compiler.compile(config, this.messageFiles);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private MessageCompiler getMessageCompiler() throws MojoExecutionException {
        MessageCompiler mc;
        try {
            mc = this.manager.getMessageCompiler(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return mc;
    }
}

