/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.mojo.natives.manager.LinkerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class NativeLinkMojo
extends AbstractNativeMojo {
    private String compilerProvider;
    private String linkerProvider;
    private String linkerExecutable;
    private List linkerStartOptions;
    private List linkerMiddleOptions;
    private List linkerEndOptions;
    private List linkingOrderLibs;
    private Map projectArtifactMap;
    private String linkerSecondaryOutputExtensions = "";
    private LinkerManager manager;
    private ArtifactFactory artifactFactory;
    private File externalLibDirectory;
    private String classifier = null;
    private boolean attach = true;
    private LinkerConfiguration config;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.classifier)) {
            this.classifier = null;
        }
        Linker linker = this.getLinker();
        this.config = this.createLinkerConfiguration();
        try {
            List allCompilerOuputFiles = (List)this.getPluginContext().get("NativeLinkerInputListName");
            linker.link(this.config, allCompilerOuputFiles);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
        catch (NativeBuildException nbe) {
            throw new MojoExecutionException(nbe.getMessage(), (Exception)((Object)nbe));
        }
        if (this.attach) {
            this.attachPrimaryArtifact();
            this.attachSecondaryArtifacts();
        }
    }

    private LinkerConfiguration createLinkerConfiguration() throws MojoExecutionException {
        LinkerConfiguration config = new LinkerConfiguration();
        config.setWorkingDirectory(this.workingDirectory);
        config.setExecutable(this.linkerExecutable);
        config.setStartOptions(NativeLinkMojo.removeEmptyOptions(this.linkerStartOptions));
        config.setMiddleOptions(NativeLinkMojo.removeEmptyOptions(this.linkerMiddleOptions));
        config.setEndOptions(NativeLinkMojo.removeEmptyOptions(this.linkerEndOptions));
        config.setOutputDirectory(this.outputDirectory);
        config.setOutputFileName(this.project.getBuild().getFinalName());
        config.setOutputFileExtension(this.project.getArtifact().getArtifactHandler().getExtension());
        config.setExternalLibDirectory(this.externalLibDirectory);
        config.setExternalLibFileNames(this.getLibFileNames());
        config.setEnvFactoryName(this.envFactoryName);
        return config;
    }

    private Linker getLinker() throws MojoExecutionException {
        Linker linker;
        try {
            if (this.linkerProvider == null) {
                this.linkerProvider = this.compilerProvider;
            }
            linker = this.manager.getLinker(this.linkerProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return linker;
    }

    private void attachPrimaryArtifact() {
        Artifact artifact = this.project.getArtifact();
        if (null == this.classifier) {
            artifact.setFile(new File(this.outputDirectory + "/" + this.project.getBuild().getFinalName() + "." + this.project.getArtifact().getArtifactHandler().getExtension()));
        } else {
            DefaultArtifact clone = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionRange().cloneOf(), artifact.getScope(), artifact.getType(), this.classifier, artifact.getArtifactHandler(), artifact.isOptional());
            clone.setRelease(artifact.isRelease());
            clone.setResolvedVersion(artifact.getVersion());
            clone.setResolved(artifact.isResolved());
            clone.setFile(artifact.getFile());
            if (artifact.getAvailableVersions() != null) {
                clone.setAvailableVersions(new ArrayList(artifact.getAvailableVersions()));
            }
            clone.setBaseVersion(artifact.getBaseVersion());
            clone.setDependencyFilter(artifact.getDependencyFilter());
            if (artifact.getDependencyTrail() != null) {
                clone.setDependencyTrail(new ArrayList(artifact.getDependencyTrail()));
            }
            clone.setDownloadUrl(artifact.getDownloadUrl());
            clone.setRepository(artifact.getRepository());
            clone.setFile(new File(this.outputDirectory + "/" + this.project.getBuild().getFinalName() + "." + this.project.getArtifact().getArtifactHandler().getExtension()));
            this.project.setArtifact((Artifact)clone);
        }
    }

    private void attachSecondaryArtifacts() {
        String[] tokens = StringUtils.split((String)this.linkerSecondaryOutputExtensions, (String)",");
        for (int i = 0; i < tokens.length; ++i) {
            Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.classifier, tokens[i].trim());
            artifact.setFile(new File(this.outputDirectory + "/" + this.project.getBuild().getFinalName() + "." + tokens[i].trim()));
            this.project.addAttachedArtifact(artifact);
        }
    }

    private List getLibFileNames() throws MojoExecutionException {
        List<String> libList = new ArrayList();
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String libFileName = FileUtils.filename((String)this.getDependencyFile(artifact, true).getPath());
            libList.add(libFileName);
        }
        libList = this.reorderLibDependencies(libList);
        return libList;
    }

    private List getDependenciesFileOrderList() throws MojoExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        if (this.linkingOrderLibs != null) {
            Iterator i = this.linkingOrderLibs.iterator();
            while (i.hasNext()) {
                String element = i.next().toString();
                Artifact artifact = (Artifact)this.projectArtifactMap.get(element);
                if (artifact != null) {
                    String libFileName = FileUtils.filename((String)this.getDependencyFile(artifact, false).getPath());
                    list.add(libFileName);
                    continue;
                }
                throw new MojoExecutionException(element + " not found on project dependencies.");
            }
        }
        return list;
    }

    private List reorderLibDependencies(List libs) throws MojoExecutionException {
        List requestedOrderList = this.getDependenciesFileOrderList();
        if (requestedOrderList.size() != 0) {
            Iterator i = requestedOrderList.iterator();
            while (i.hasNext()) {
                libs.remove(i.next());
            }
            i = libs.iterator();
            while (i.hasNext()) {
                requestedOrderList.add(i.next());
            }
            return requestedOrderList;
        }
        return libs;
    }

    private File getDependencyFile(Artifact artifact, boolean doCopy) throws MojoExecutionException {
        File newLocation = artifact.getFile();
        newLocation = new File(this.externalLibDirectory, artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension());
        try {
            if (doCopy && (!newLocation.exists() || newLocation.lastModified() <= artifact.getFile().lastModified())) {
                FileUtils.copyFile((File)artifact.getFile(), (File)newLocation);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to copy dependency to staging area.  Could not copy " + artifact.getFile() + " to " + newLocation, (Exception)ioe);
        }
        return newLocation;
    }

    protected LinkerConfiguration getLgetLinkerConfiguration() {
        return this.config;
    }
}

