/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.compiler.Compiler;
import org.codehaus.mojo.natives.compiler.CompilerConfiguration;
import org.codehaus.mojo.natives.manager.CompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;

public class NativeCompileMojo
extends AbstractNativeMojo {
    private String compilerProvider;
    private String objectFileExtension;
    private String compilerExecutable;
    private List compilerStartOptions;
    private List compilerMiddleOptions;
    private List compilerEndOptions;
    private String javahOS;
    private File jdkIncludePath;
    protected NativeSources[] sources = new NativeSources[0];
    private CompilerManager manager;
    private CompilerConfiguration config;

    public void execute() throws MojoExecutionException {
        List objectFiles;
        Compiler compiler;
        try {
            compiler = this.manager.getCompiler(this.compilerProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        if (this.javahOS != null) {
            this.addJavaHIncludePaths();
        }
        this.addAdditionalIncludePath();
        CompilerConfiguration config = this.createProviderConfiguration();
        try {
            objectFiles = compiler.compile(config, NativeSources.getAllSourceFiles((NativeSources[])this.sources));
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.saveCompilerOutputFilePaths(objectFiles);
    }

    private void addJavaHIncludePaths() {
        ArrayList<NativeSources> sourceArray = new ArrayList<NativeSources>(Arrays.asList(this.sources));
        NativeSources jdkIncludeSource = new NativeSources();
        jdkIncludeSource.setDirectory(this.jdkIncludePath);
        jdkIncludeSource.setDependencyAnalysisParticipation(false);
        sourceArray.add(jdkIncludeSource);
        File jdkOsIncludeDir = new File(this.jdkIncludePath, this.javahOS);
        NativeSources jdkIncludeOsSource = new NativeSources();
        jdkIncludeOsSource.setDirectory(jdkOsIncludeDir);
        jdkIncludeOsSource.setDependencyAnalysisParticipation(false);
        sourceArray.add(jdkIncludeOsSource);
        this.sources = sourceArray.toArray(new NativeSources[sourceArray.size()]);
    }

    private void addAdditionalIncludePath() {
        List additionalIncludePaths = this.project.getCompileSourceRoots();
        if (additionalIncludePaths == null || additionalIncludePaths.size() < 2) {
            return;
        }
        if (this.sources == null) {
            return;
        }
        ArrayList<NativeSources> sourceArray = new ArrayList<NativeSources>(Arrays.asList(this.sources));
        if (additionalIncludePaths.size() > 1) {
            for (int i = 1; i < additionalIncludePaths.size(); ++i) {
                File genIncludeDir = new File(additionalIncludePaths.get(i).toString());
                NativeSources genIncludeSource = new NativeSources();
                genIncludeSource.setDirectory(genIncludeDir);
                sourceArray.add(genIncludeSource);
            }
        }
        this.sources = sourceArray.toArray(new NativeSources[sourceArray.size()]);
    }

    protected CompilerConfiguration createProviderConfiguration() throws MojoExecutionException {
        this.config = new CompilerConfiguration();
        this.config.setWorkingDirectory(this.project.getBasedir());
        this.config.setExecutable(this.compilerExecutable);
        this.config.setStartOptions(AbstractNativeMojo.removeEmptyOptions(this.compilerStartOptions));
        this.config.setMiddleOptions(AbstractNativeMojo.removeEmptyOptions(this.compilerMiddleOptions));
        this.config.setEndOptions(AbstractNativeMojo.removeEmptyOptions(this.compilerEndOptions));
        this.config.setIncludePaths(NativeSources.getIncludePaths((NativeSources[])this.sources));
        this.config.setSystemIncludePaths(NativeSources.getSystemIncludePaths((NativeSources[])this.sources));
        this.config.setOutputDirectory(this.outputDirectory);
        this.config.setEnvFactoryName(this.envFactoryName);
        this.config.setObjectFileExtension(this.objectFileExtension);
        return this.config;
    }

    protected CompilerConfiguration getCompilerConfiguration() {
        return this.config;
    }
}

