/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.compiler.MessageCompiler;
import org.codehaus.mojo.natives.compiler.MessageCompilerConfiguration;
import org.codehaus.mojo.natives.manager.MessageCompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.NativeMojoUtils;

public class NativeMessageCompileMojo
extends AbstractMojo {
    private String provider;
    private String[] options;
    protected MavenProject project;
    protected File outputDirectory;
    protected File[] messageFiles;
    private MessageCompilerManager manager;
    protected String envFactoryName;

    public void execute() throws MojoExecutionException {
        MessageCompiler compiler;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            compiler = this.manager.getMessageCompiler(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        MessageCompilerConfiguration config = new MessageCompilerConfiguration();
        config.setBaseDir(this.project.getBasedir());
        config.setOutputDirectory(this.outputDirectory);
        config.setOptions(NativeMojoUtils.trimParams(this.options));
        config.setEnvFactoryName(this.envFactoryName);
        try {
            compiler.compile(config, this.messageFiles);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }
}

