/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.mojo.natives.manager.LinkerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class NativeLinkMojo
extends AbstractNativeMojo {
    private String compilerProvider;
    private String linkerProvider;
    private String linkerExecutable;
    private String[] linkerStartOptions = new String[0];
    private String[] linkerMiddleOptions = new String[0];
    private String[] linkerEndOptions = new String[0];
    private List linkingOrderLibs;
    private Map projectArtifactMap;
    private String linkerSecondaryOutputExtensions = "";
    private LinkerManager manager;
    private ArtifactFactory artifactFactory;
    private File externalLibDirectory;

    public void execute() throws MojoExecutionException {
        Linker linker = this.getLinker();
        LinkerConfiguration config = this.getLinkerConfiguration();
        try {
            List allCompilerOuputFiles = (List)this.getPluginContext().get("NativeLinkerInputListName");
            linker.link(config, allCompilerOuputFiles);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
        catch (NativeBuildException nbe) {
            throw new MojoExecutionException(nbe.getMessage(), (Exception)((Object)nbe));
        }
        Artifact primaryArtifact = this.project.getArtifact();
        primaryArtifact.setFile(new File(this.outputDirectory + "/" + this.project.getBuild().getFinalName() + "." + this.project.getArtifact().getArtifactHandler().getExtension()));
        this.attachSecondaryArtifacts();
    }

    private LinkerConfiguration getLinkerConfiguration() throws MojoExecutionException {
        LinkerConfiguration config = new LinkerConfiguration();
        config.setWorkingDirectory(this.project.getBasedir());
        config.setExecutable(this.linkerExecutable);
        config.setStartOptions(AbstractNativeMojo.removeEmptyOptions(this.linkerStartOptions));
        config.setMiddleOptions(AbstractNativeMojo.removeEmptyOptions(this.linkerMiddleOptions));
        config.setEndOptions(AbstractNativeMojo.removeEmptyOptions(this.linkerEndOptions));
        config.setOutputDirectory(this.outputDirectory);
        config.setOutputFileName(this.project.getBuild().getFinalName());
        config.setOutputFileExtension(this.project.getArtifact().getArtifactHandler().getExtension());
        config.setExternalLibDirectory(this.externalLibDirectory);
        config.setExternalLibFileNames(this.getLibFileNames());
        config.setEnvFactoryName(this.envFactoryName);
        return config;
    }

    private Linker getLinker() throws MojoExecutionException {
        Linker linker;
        try {
            if (this.linkerProvider == null) {
                this.linkerProvider = this.compilerProvider;
            }
            linker = this.manager.getLinker(this.linkerProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return linker;
    }

    private void attachSecondaryArtifacts() {
        String[] tokens = StringUtils.split((String)this.linkerSecondaryOutputExtensions, (String)",");
        for (int i = 0; i < tokens.length; ++i) {
            Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, tokens[i].trim());
            artifact.setFile(new File(this.outputDirectory + "/" + this.project.getBuild().getFinalName() + "." + tokens[i].trim()));
            this.project.addAttachedArtifact(artifact);
        }
    }

    private List getLibFileNames() throws MojoExecutionException {
        List<String> libList = new ArrayList();
        Set artifacts = this.project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String libFileName = FileUtils.filename((String)this.getDependencyFile(artifact, true).getPath());
            libList.add(libFileName);
        }
        libList = this.reorderLibDependencies(libList);
        return libList;
    }

    private List getDependenciesFileOrderList() throws MojoExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        if (this.linkingOrderLibs != null) {
            Iterator i = this.linkingOrderLibs.iterator();
            while (i.hasNext()) {
                String element = i.next().toString();
                Artifact artifact = (Artifact)this.projectArtifactMap.get(element);
                if (artifact != null) {
                    String libFileName = FileUtils.filename((String)this.getDependencyFile(artifact, false).getPath());
                    list.add(libFileName);
                    continue;
                }
                throw new MojoExecutionException(element + " not found on project dependencies.");
            }
        }
        return list;
    }

    private List reorderLibDependencies(List libs) throws MojoExecutionException {
        List requestedOrderList = this.getDependenciesFileOrderList();
        if (requestedOrderList.size() != 0) {
            Iterator i = requestedOrderList.iterator();
            while (i.hasNext()) {
                libs.remove(i.next());
            }
            i = libs.iterator();
            while (i.hasNext()) {
                requestedOrderList.add(i.next());
            }
            return requestedOrderList;
        }
        return libs;
    }

    private File getDependencyFile(Artifact artifact, boolean doCopy) throws MojoExecutionException {
        File newLocation = artifact.getFile();
        newLocation = new File(this.externalLibDirectory, artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension());
        try {
            if (doCopy && (!newLocation.exists() || newLocation.lastModified() <= artifact.getFile().lastModified())) {
                FileUtils.copyFile((File)artifact.getFile(), (File)newLocation);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to copy dependency to staging area");
        }
        return newLocation;
    }
}

