/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;

public class FileSystemServlet
extends HttpServlet {
    private final FileSystem fileSystem;

    public FileSystemServlet(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Entry entry;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if ((entry = this.fileSystem.get(path)) instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)entry;
            long size = fileEntry.getSize();
            if (size >= 0L && size < Integer.MAX_VALUE) {
                resp.setContentLength((int)size);
            }
            resp.setContentType(this.getServletContext().getMimeType(fileEntry.getName()));
            LocalDateTime lastModifiedDate = LocalDateTime.ofEpochSecond(fileEntry.getLastModified() / 1000L, (int)(fileEntry.getLastModified() % 1000L), ZoneOffset.UTC);
            String formattedLastModifiedDate = lastModifiedDate.atZone(ZoneId.of("UTC")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
            resp.addHeader("Last-Modified", formattedLastModifiedDate);
            try (InputStream source = fileEntry.getInputStream();){
                IOUtils.copy((InputStream)source, (OutputStream)resp.getOutputStream());
            }
            return;
        }
        resp.sendError(404);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] parts;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if (path.endsWith("/")) {
            resp.sendError(405);
            return;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((parts = path.split("/")).length == 0) {
            resp.sendError(405);
            return;
        }
        String name = parts[parts.length - 1];
        if (StringUtils.isEmpty((String)name)) {
            resp.sendError(405);
            return;
        }
        DirectoryEntry parent = this.fileSystem.getRoot();
        for (int i = 0; i < parts.length - 1; ++i) {
            parent = new DefaultDirectoryEntry(this.fileSystem, parent, parts[i]);
        }
        FileEntry put = this.fileSystem.put(parent, name, (InputStream)req.getInputStream());
        if (put != null) {
            resp.setStatus(200);
            return;
        }
        resp.sendError(405);
    }
}

