/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;

public class MetadataFileEntry
extends BaseFileEntry {
    private final String path;
    private final ArtifactStore store;

    public MetadataFileEntry(FileSystem fileSystem, DirectoryEntry parent, String path, ArtifactStore store) {
        super(fileSystem, parent, "maven-metadata.xml");
        this.path = path;
        this.store = store;
    }

    public long getSize() throws IOException {
        try {
            Metadata metadata = this.store.getMetadata(this.path);
            MetadataXpp3Writer writer = new MetadataXpp3Writer();
            StringWriter stringWriter = new StringWriter();
            writer.write((Writer)stringWriter, metadata);
            return stringWriter.toString().getBytes().length;
        }
        catch (MetadataNotFoundException e) {
            throw new IOException("File not found", e);
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            Metadata metadata = this.store.getMetadata(this.path);
            MetadataXpp3Writer writer = new MetadataXpp3Writer();
            StringWriter stringWriter = new StringWriter();
            writer.write((Writer)stringWriter, metadata);
            return new ByteArrayInputStream(stringWriter.toString().getBytes());
        }
        catch (MetadataNotFoundException e) {
            return null;
        }
    }

    public long getLastModified() throws IOException {
        try {
            return this.store.getMetadataLastModified(this.path);
        }
        catch (MetadataNotFoundException e) {
            throw new IOException("File not found", e);
        }
    }
}

