/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;

public class CompositeArtifactStore
extends BaseArtifactStore {
    private final ArtifactStore[] stores;

    public CompositeArtifactStore(ArtifactStore[] stores) {
        this.stores = stores;
    }

    public Set<String> getGroupIds(String parentGroupId) {
        TreeSet<String> result = new TreeSet<String>();
        for (ArtifactStore store : this.stores) {
            Set groupIds = store.getGroupIds(parentGroupId);
            if (groupIds == null) continue;
            result.addAll(groupIds);
        }
        return result;
    }

    public Set<String> getArtifactIds(String groupId) {
        TreeSet<String> result = new TreeSet<String>();
        for (ArtifactStore store : this.stores) {
            Set artifactIds = store.getArtifactIds(groupId);
            if (artifactIds == null) continue;
            result.addAll(artifactIds);
        }
        return result;
    }

    public Set<String> getVersions(String groupId, String artifactId) {
        TreeSet<String> result = new TreeSet<String>();
        for (ArtifactStore store : this.stores) {
            Set versions = store.getVersions(groupId, artifactId);
            if (versions == null) continue;
            result.addAll(versions);
        }
        return result;
    }

    public Set<Artifact> getArtifacts(String groupId, String artifactId, String version) {
        TreeSet<Artifact> result = new TreeSet<Artifact>();
        for (ArtifactStore store : this.stores) {
            Set artifacts = store.getArtifacts(groupId, artifactId, version);
            if (artifacts == null) continue;
            result.addAll(artifacts);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (ArtifactStore store : this.stores) {
            try {
                return store.getLastModified(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (ArtifactStore store : this.stores) {
            try {
                return store.getSize(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (ArtifactStore store : this.stores) {
            try {
                return store.get(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new IOException("Read-only store");
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Metadata result = null;
        for (ArtifactStore store : this.stores) {
            try {
                Metadata metadata = store.getMetadata(path);
                if (result == null) {
                    result = metadata;
                    continue;
                }
                result.merge(metadata);
            }
            catch (MetadataNotFoundException metadataNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new MetadataNotFoundException(path);
        }
        return result;
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        boolean found = false;
        long lastModified = 0L;
        for (ArtifactStore store : this.stores) {
            try {
                if (!found) {
                    lastModified = store.getMetadataLastModified(path);
                    found = true;
                    continue;
                }
                lastModified = Math.max(lastModified, store.getMetadataLastModified(path));
            }
            catch (MetadataNotFoundException metadataNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new MetadataNotFoundException(path);
        }
        return lastModified;
    }

    public ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        boolean found = false;
        ArchetypeCatalog result = new ArchetypeCatalog();
        for (ArtifactStore store : this.stores) {
            try {
                ArchetypeCatalog partial = store.getArchetypeCatalog();
                result.getArchetypes().addAll(partial.getArchetypes());
                found = true;
            }
            catch (ArchetypeCatalogNotFoundException archetypeCatalogNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new ArchetypeCatalogNotFoundException();
        }
        return result;
    }

    public long getArchetypeCatalogLastModified() throws IOException, ArchetypeCatalogNotFoundException {
        boolean found = false;
        long lastModified = 0L;
        for (ArtifactStore store : this.stores) {
            try {
                if (!found) {
                    lastModified = store.getArchetypeCatalogLastModified();
                    found = true;
                    continue;
                }
                lastModified = Math.max(lastModified, store.getArchetypeCatalogLastModified());
            }
            catch (ArchetypeCatalogNotFoundException archetypeCatalogNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new ArchetypeCatalogNotFoundException();
        }
        return lastModified;
    }
}

