/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;

public class ArchetypeCatalogFileEntry
extends BaseFileEntry {
    private final ArtifactStore store;

    public ArchetypeCatalogFileEntry(FileSystem fileSystem, DirectoryEntry parent, ArtifactStore store) {
        super(fileSystem, parent, "archetype-catalog.xml");
        this.store = store;
    }

    public long getSize() throws IOException {
        try {
            ArchetypeCatalog metadata = this.store.getArchetypeCatalog();
            ArchetypeCatalogXpp3Writer writer = new ArchetypeCatalogXpp3Writer();
            StringWriter stringWriter = new StringWriter();
            writer.write((Writer)stringWriter, metadata);
            return stringWriter.toString().getBytes().length;
        }
        catch (ArchetypeCatalogNotFoundException e) {
            throw new IOException("File not found", e);
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            ArchetypeCatalog metadata = this.store.getArchetypeCatalog();
            ArchetypeCatalogXpp3Writer writer = new ArchetypeCatalogXpp3Writer();
            StringWriter stringWriter = new StringWriter();
            writer.write((Writer)stringWriter, metadata);
            return new ByteArrayInputStream(stringWriter.toString().getBytes());
        }
        catch (ArchetypeCatalogNotFoundException e) {
            return null;
        }
    }

    public long getLastModified() throws IOException {
        try {
            return this.store.getArchetypeCatalogLastModified();
        }
        catch (ArchetypeCatalogNotFoundException e) {
            throw new IOException("File not found", e);
        }
    }
}

