/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.digest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.digest.BaseDigestFileEntryFactory;

public class MD5DigestFileEntry
extends BaseFileEntry {
    private static final long serialVersionUID = 1L;
    private final FileEntry entry;

    public MD5DigestFileEntry(FileSystem fileSystem, DirectoryEntry parent, FileEntry entry) {
        super(fileSystem, parent, entry.getName() + ".md5");
        this.entry = entry;
    }

    public long getLastModified() throws IOException {
        return this.entry.getLastModified();
    }

    public long getSize() throws IOException {
        return 32L;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }

    private byte[] getContent() throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.reset();
            byte[] buffer = new byte[8192];
            try (InputStream is = this.entry.getInputStream();){
                int read;
                while ((read = is.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
            }
            String md5 = StringUtils.leftPad((String)new BigInteger(1, digest.digest()).toString(16), (int)32, (String)"0");
            return md5.getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to calculate hash", e);
        }
    }

    public static class Factory
    extends BaseDigestFileEntryFactory {
        @Override
        public String getType() {
            return ".md5";
        }

        @Override
        public FileEntry create(FileSystem fileSystem, DirectoryEntry parent, FileEntry entry) {
            return new MD5DigestFileEntry(fileSystem, parent, entry);
        }
    }
}

