/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileSystem;

public class MemoryFileEntry
extends BaseFileEntry {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final byte[] content;
    private final long lastModified;

    public MemoryFileEntry(FileSystem fileSystem, DirectoryEntry parent, String name, byte[] content) {
        super(fileSystem, parent, name);
        this.content = content == null ? EMPTY_BYTE_ARRAY : content;
        this.lastModified = System.currentTimeMillis();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getSize() {
        return this.content.length;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }
}

