/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;

public class ArtifactFileEntry
extends BaseFileEntry {
    private static final long serialVersionUID = 1L;
    private final Artifact artifact;
    private final ArtifactStore store;

    protected ArtifactFileEntry(FileSystem fileSystem, DirectoryEntry parent, Artifact artifact, ArtifactStore store) {
        super(fileSystem, parent, artifact.getName());
        this.artifact = artifact;
        this.store = store;
    }

    public long getSize() throws IOException {
        try {
            return this.store.getSize(this.artifact);
        }
        catch (ArtifactNotFoundException e) {
            IOException ioe = new IOException("Artifact does not exist");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.store.get(this.artifact);
        }
        catch (ArtifactNotFoundException e) {
            IOException ioe = new IOException("Artifact does not exist");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public long getLastModified() throws IOException {
        try {
            return this.store.getLastModified(this.artifact);
        }
        catch (ArtifactNotFoundException e) {
            IOException ioe = new IOException("Artifact does not exist");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }
}

