/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.mojo.mrm.plugin.AbstractStartMojo;
import org.codehaus.mojo.mrm.plugin.ArtifactStoreFactory;
import org.codehaus.mojo.mrm.plugin.ConsoleScanner;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;
import org.codehaus.mojo.mrm.plugin.FileSystemServer;

@Mojo(name="run", requiresProject=false, requiresDirectInvocation=true, threadSafe=true)
public class RunMojo
extends AbstractStartMojo {
    @Inject
    public RunMojo(FactoryHelper factoryHelper, @Named(value="proxyRepo") ArtifactStoreFactory proxyRepo) {
        super(factoryHelper, proxyRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.session.getSettings().isInteractiveMode()) {
            throw new MojoExecutionException("Cannot run a mock repository in batch mode (as there is no way to signal shutdown) use mrm:start instead");
        }
        FileSystemServer mrm = this.createFileSystemServer(this.createArtifactStore());
        this.getLog().info((CharSequence)"Starting Mock Repository Manager");
        mrm.ensureStarted();
        String url = mrm.getUrl();
        try {
            this.getLog().info((CharSequence)("Mock Repository Manager " + url + " is started."));
            ConsoleScanner consoleScanner = new ConsoleScanner();
            consoleScanner.start();
            this.getLog().info((CharSequence)"Hit ENTER on the console to stop the Mock Repository Manager and continue the build.");
            consoleScanner.waitForFinished();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.getLog().info((CharSequence)("Stopping Mock Repository Manager " + url));
            mrm.finish();
            try {
                mrm.waitForFinished();
                this.getLog().info((CharSequence)("Mock Repository Manager " + url + " is stopped."));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

