/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;

public class ProxyArtifactStore
extends BaseArtifactStore {
    private final RepositoryMetadataManager repositoryMetadataManager;
    private final List remotePluginRepositories;
    private final ArtifactRepository localRepository;
    private final ArtifactFactory artifactFactory;
    private final List remoteRepositories;
    private final ArtifactResolver artifactResolver;
    private final Log log;
    private final VersionRange anyVersion;
    private final Map children = new HashMap();

    public ProxyArtifactStore(RepositoryMetadataManager repositoryMetadataManager, List remoteArtifactRepositories, List remotePluginRepositories, ArtifactRepository localRepository, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, Log log) {
        this.repositoryMetadataManager = repositoryMetadataManager;
        this.remotePluginRepositories = remotePluginRepositories;
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
        this.log = log;
        this.remoteRepositories = new ArrayList();
        this.remoteRepositories.addAll(remoteArtifactRepositories);
        this.remoteRepositories.addAll(remotePluginRepositories);
        try {
            this.anyVersion = VersionRange.createFromVersionSpec((String)"[0,]");
        }
        catch (InvalidVersionSpecificationException e) {
            IllegalStateException ise = new IllegalStateException("[0,] should always be a valid version specification");
            ise.initCause(e);
            throw ise;
        }
    }

    private synchronized void addResolved(Artifact artifact) {
        String path = artifact.getGroupId().replace('.', '/') + '/' + artifact.getArtifactId() + "/" + artifact.getVersion();
        HashMap<String, Artifact> children = (HashMap<String, Artifact>)this.children.get(path);
        if (children == null) {
            children = new HashMap<String, Artifact>();
            this.children.put(path, children);
        }
        children.put(artifact.getName(), artifact);
        this.addResolved(path);
    }

    private synchronized void addResolved(String path) {
        int index = path.lastIndexOf(47);
        while (index > 0) {
            String name = path.substring(index + 1);
            HashMap<String, Object> children = (HashMap<String, Object>)this.children.get(path = path.substring(0, index));
            if (children == null) {
                children = new HashMap<String, Object>();
                this.children.put(path, children);
            }
            children.put(name, null);
            index = path.lastIndexOf(47);
        }
        if (!StringUtils.isEmpty((String)path)) {
            HashMap<String, Object> children = (HashMap<String, Object>)this.children.get("");
            if (children == null) {
                children = new HashMap<String, Object>();
                this.children.put("", children);
            }
            children.put(path, null);
        }
    }

    public synchronized Set getGroupIds(String parentGroupId) {
        String path = parentGroupId.replace('.', '/');
        Map children = (Map)this.children.get(path);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet();
        Iterator i = children.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() != null) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public synchronized Set getArtifactIds(String groupId) {
        String path = groupId.replace('.', '/');
        Map children = (Map)this.children.get(path);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet();
        Iterator i = children.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() != null) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public synchronized Set getVersions(String groupId, String artifactId) {
        String path = groupId.replace('.', '/') + '/' + artifactId;
        Map children = (Map)this.children.get(path);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet();
        Iterator i = children.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() != null) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public synchronized Set getArtifacts(String groupId, String artifactId, String version) {
        String path = groupId.replace('.', '/') + '/' + artifactId + "/" + version;
        Map children = (Map)this.children.get(path);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator i = children.values().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (a == null) continue;
            result.add(a);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getTimestampVersion(), artifact.getType(), artifact.getClassifier());
        try {
            this.artifactResolver.resolve(mavenArtifact, this.remoteRepositories, this.localRepository);
            File file = mavenArtifact.getFile();
            if (file != null && file.isFile()) {
                this.addResolved(artifact);
                return file.lastModified();
            }
            throw new ArtifactNotFoundException(artifact);
        }
        catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
            ArtifactNotFoundException anfe = new ArtifactNotFoundException(artifact);
            anfe.initCause((Throwable)e);
            throw anfe;
        }
        catch (ArtifactResolutionException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getTimestampVersion(), artifact.getType(), artifact.getClassifier());
        try {
            this.artifactResolver.resolve(mavenArtifact, this.remoteRepositories, this.localRepository);
            File file = mavenArtifact.getFile();
            if (file != null && file.isFile()) {
                this.addResolved(artifact);
                return file.length();
            }
            throw new ArtifactNotFoundException(artifact);
        }
        catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
            throw new ArtifactNotFoundException(artifact, (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        org.apache.maven.artifact.Artifact mavenArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getTimestampVersion(), artifact.getType(), artifact.getClassifier());
        try {
            this.artifactResolver.resolve(mavenArtifact, this.remoteRepositories, this.localRepository);
            File file = mavenArtifact.getFile();
            if (file != null && file.isFile()) {
                this.addResolved(artifact);
                return new FileInputStream(file);
            }
            throw new ArtifactNotFoundException(artifact);
        }
        catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
            ArtifactNotFoundException anfe = new ArtifactNotFoundException(artifact);
            anfe.initCause((Throwable)e);
            throw anfe;
        }
        catch (ArtifactResolutionException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Iterator i;
        Metadata artifactMetadata;
        SnapshotArtifactRepositoryMetadata artifactRepositoryMetadata;
        org.apache.maven.artifact.Artifact artifact;
        int index = (path = StringUtils.strip((String)path, (String)"/")).lastIndexOf(47);
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        String version = index2 == -1 ? null : path.substring(index + 1);
        String artifactId = index2 == -1 ? null : path.substring(index2 + 1, index);
        String groupId = index2 == -1 ? null : path.substring(0, index2).replace('/', '.');
        Metadata metadata = new Metadata();
        boolean foundSomething = false;
        if (version != null && version.endsWith("-SNAPSHOT") && !StringUtils.isEmpty((String)artifactId) && !StringUtils.isEmpty((String)groupId)) {
            artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "pom", null, "compile");
            artifactRepositoryMetadata = new SnapshotArtifactRepositoryMetadata(artifact);
            try {
                this.repositoryMetadataManager.resolve((RepositoryMetadata)artifactRepositoryMetadata, this.remoteRepositories, this.localRepository);
                artifactMetadata = artifactRepositoryMetadata.getMetadata();
                if (artifactMetadata.getVersioning() != null && artifactMetadata.getVersioning().getSnapshot() != null) {
                    foundSomething = true;
                    metadata.setGroupId(groupId);
                    metadata.setArtifactId(artifactId);
                    metadata.setVersion(version);
                    metadata.merge(artifactMetadata);
                }
                try {
                    if (artifactMetadata.getVersioning() != null && !artifactMetadata.getVersioning().getSnapshotVersions().isEmpty()) {
                        i = artifactMetadata.getVersioning().getSnapshotVersions().iterator();
                        while (i.hasNext()) {
                            SnapshotVersion v = (SnapshotVersion)i.next();
                            metadata.getVersioning().addSnapshotVersion(v);
                            if (!v.getVersion().endsWith("-SNAPSHOT")) continue;
                            this.addResolved(new Artifact(groupId, artifactId, version, v.getClassifier(), v.getExtension()));
                        }
                    }
                }
                catch (NoSuchMethodError e) {
                }
            }
            catch (RepositoryMetadataResolutionException e) {
                this.log.debug((Throwable)e);
            }
        }
        artifactId = index == -1 ? null : path.substring(index + 1);
        String string = groupId = index == -1 ? null : path.substring(0, index).replace('/', '.');
        if (!StringUtils.isEmpty((String)artifactId) && !StringUtils.isEmpty((String)groupId)) {
            artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, this.anyVersion, "pom", null, "compile");
            artifactRepositoryMetadata = new ArtifactRepositoryMetadata(artifact);
            try {
                this.repositoryMetadataManager.resolve((RepositoryMetadata)artifactRepositoryMetadata, this.remoteRepositories, this.localRepository);
                artifactMetadata = artifactRepositoryMetadata.getMetadata();
                if (artifactMetadata.getVersioning() != null) {
                    foundSomething = true;
                    if (StringUtils.isEmpty((String)metadata.getGroupId())) {
                        metadata.setGroupId(groupId);
                        metadata.setArtifactId(artifactId);
                    }
                    metadata.merge(artifactMetadata);
                    i = artifactMetadata.getVersioning().getVersions().iterator();
                    while (i.hasNext()) {
                        this.addResolved(path + "/" + i.next());
                    }
                }
            }
            catch (RepositoryMetadataResolutionException e) {
                this.log.debug((Throwable)e);
            }
        }
        groupId = path.replace('/', '.');
        GroupRepositoryMetadata groupRepositoryMetadata = new GroupRepositoryMetadata(groupId);
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)groupRepositoryMetadata, this.remotePluginRepositories, this.localRepository);
            foundSomething = true;
            metadata.merge(groupRepositoryMetadata.getMetadata());
            Iterator i2 = groupRepositoryMetadata.getMetadata().getPlugins().iterator();
            while (i2.hasNext()) {
                Plugin plugin = (Plugin)i2.next();
                this.addResolved(path + "/" + plugin.getArtifactId());
            }
        }
        catch (RepositoryMetadataResolutionException e) {
            this.log.debug((Throwable)e);
        }
        if (!foundSomething) {
            throw new MetadataNotFoundException(path);
        }
        this.addResolved(path);
        return metadata;
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        Metadata metadata = this.getMetadata(path);
        if (!(metadata == null || StringUtils.isEmpty((String)metadata.getGroupId()) && StringUtils.isEmpty((String)metadata.getArtifactId()) && StringUtils.isEmpty((String)metadata.getVersion()) && (metadata.getPlugins() == null || metadata.getPlugins().isEmpty()) && (metadata.getVersioning() == null || StringUtils.isEmpty((String)metadata.getVersioning().getLastUpdated()) && StringUtils.isEmpty((String)metadata.getVersioning().getLatest()) && StringUtils.isEmpty((String)metadata.getVersioning().getRelease()) && (metadata.getVersioning().getVersions() == null || metadata.getVersioning().getVersions().isEmpty()) && metadata.getVersioning().getSnapshot() == null))) {
            return System.currentTimeMillis();
        }
        throw new MetadataNotFoundException(path);
    }
}

