/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.api;

import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileSystem;

public abstract class BaseFileSystem
implements FileSystem {
    private final DirectoryEntry root = new DefaultDirectoryEntry(this, null, "");

    @Override
    public DirectoryEntry getRoot() {
        return this.root;
    }

    @Override
    public Entry get(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return this.root;
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.root;
        }
        DirectoryEntry parent = this.root;
        for (int i = 0; i < parts.length - 1; ++i) {
            parent = new DefaultDirectoryEntry(this, parent, parts[i]);
        }
        return this.get(parent, parts[parts.length - 1]);
    }

    protected Entry get(DirectoryEntry parent, String name) {
        parent.getClass();
        Entry[] entries = this.listEntries(parent);
        if (entries != null) {
            for (Entry entry : entries) {
                if (!name.equals(entry.getName())) continue;
                return entry;
            }
        }
        return null;
    }
}

