/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.mojo.license.download.ProjectLicense;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LicenseSummaryReader {
    public static List<ProjectLicenseInfo> parseLicenseSummary(File licSummaryFile) throws IOException, ParserConfigurationException, SAXException {
        if (licSummaryFile.exists()) {
            try (InputStream in = Files.newInputStream(licSummaryFile.toPath(), new OpenOption[0]);){
                List<ProjectLicenseInfo> list = LicenseSummaryReader.parseLicenseSummary(in);
                return list;
            }
        }
        return Collections.emptyList();
    }

    public static List<ProjectLicenseInfo> parseLicenseSummary(InputStream licSummaryIS) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<ProjectLicenseInfo> dependencies = new ArrayList<ProjectLicenseInfo>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(licSummaryIS);
        doc.getDocumentElement().normalize();
        Element documentElement = doc.getDocumentElement();
        Node dependenciesNode = documentElement.getElementsByTagName("dependencies").item(0);
        NodeList dependencyNodes = dependenciesNode.getChildNodes();
        for (int i = 0; i < dependencyNodes.getLength(); ++i) {
            Node dependencyNode = dependencyNodes.item(i);
            if (dependencyNode.getNodeType() != 1) continue;
            dependencies.add(LicenseSummaryReader.parseDependencyNode(dependencyNode));
        }
        return dependencies;
    }

    private static ProjectLicenseInfo parseDependencyNode(Node dependencyNode) {
        ProjectLicenseInfo dependency = new ProjectLicenseInfo();
        NodeList depElements = dependencyNode.getChildNodes();
        for (int i = 0; i < depElements.getLength(); ++i) {
            Node node = depElements.item(i);
            if (node.getNodeName().equals("groupId")) {
                dependency.setGroupId(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("artifactId")) {
                dependency.setArtifactId(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("version")) {
                dependency.setVersion(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("licenses")) {
                Map.Entry<Boolean, List<ProjectLicense>> entry = LicenseSummaryReader.parseLicenses(node);
                dependency.setLicenses(entry.getValue());
                dependency.setApproved(entry.getKey());
                continue;
            }
            if (!node.getNodeName().equals("matchLicenses")) continue;
            dependency.setHasMatchLicenses(true);
            dependency.setMatchLicenses(LicenseSummaryReader.parseLicenses(node).getValue());
        }
        return dependency;
    }

    private static Map.Entry<Boolean, List<ProjectLicense>> parseLicenses(Node node) {
        ArrayList<ProjectLicense> result = new ArrayList<ProjectLicense>();
        NodeList licensesChildNodes = node.getChildNodes();
        Node approvedNode = node.getAttributes().getNamedItem("approved");
        boolean approved = Boolean.parseBoolean(approvedNode != null ? approvedNode.getNodeValue() : "false");
        for (int j = 0; j < licensesChildNodes.getLength(); ++j) {
            Node licensesChildNode = licensesChildNodes.item(j);
            String nodeName = licensesChildNode.getNodeName();
            if (!nodeName.equals("license")) continue;
            if (approved) {
                throw new IllegalStateException("Cannot combine approved=\"true\" with <license> elements");
            }
            result.add(LicenseSummaryReader.parseLicense(licensesChildNode));
        }
        return new AbstractMap.SimpleImmutableEntry<Boolean, List<ProjectLicense>>(approved, result);
    }

    private static ProjectLicense parseLicense(Node licenseNode) {
        ProjectLicense license = new ProjectLicense();
        NodeList licenseElements = licenseNode.getChildNodes();
        for (int i = 0; i < licenseElements.getLength(); ++i) {
            Node node = licenseElements.item(i);
            if (node.getNodeName().equals("name")) {
                license.setName(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("url")) {
                license.setUrl(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("distribution")) {
                license.setDistribution(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("comments")) {
                license.setComments(node.getTextContent());
                continue;
            }
            if (!node.getNodeName().equals("file")) continue;
            license.setFile(node.getTextContent());
        }
        return license;
    }
}

