/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=DependenciesTool.class, hint="default")
public class DependenciesTool {
    private static final Logger LOG = LoggerFactory.getLogger(DependenciesTool.class);
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Requirement
    private ProjectBuilder mavenProjectBuilder;
    @Requirement
    private MavenSession mavenSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, MavenProject> loadProjectDependencies(ResolvedProjectDependencies artifacts, MavenProjectDependenciesConfigurator configuration, List<ArtifactRepository> remoteRepositories, SortedMap<String, MavenProject> cache) {
        ArtifactFilters artifactFilters = configuration.getArtifactFilters();
        boolean excludeTransitiveDependencies = configuration.isExcludeTransitiveDependencies();
        Set<Artifact> depArtifacts = configuration.isIncludeTransitiveDependencies() ? artifacts.getAllDependencies() : artifacts.getDirectDependencies();
        boolean verbose = configuration.isVerbose();
        TreeMap<String, MavenProject> result = new TreeMap<String, MavenProject>();
        HashMap<String, Artifact> excludeArtifacts = new HashMap<String, Artifact>();
        HashMap<String, Artifact> includeArtifacts = new HashMap<String, Artifact>();
        TreeMap<String, MavenProject> localCache = new TreeMap<String, MavenProject>();
        if (cache != null) {
            SortedMap<String, MavenProject> sortedMap = cache;
            synchronized (sortedMap) {
                localCache.putAll(cache);
            }
        }
        ProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest()).setValidationLevel(0).setResolveDependencies(false).setProcessPlugins(false).setRemoteRepositories(remoteRepositories);
        for (Artifact artifact : depArtifacts) {
            MavenProject depMavenProject;
            excludeArtifacts.put(artifact.getId(), artifact);
            if ("license.properties".equals(artifact.getType())) continue;
            if (!artifactFilters.isIncluded(artifact)) {
                LOG.debug("Excluding artifact {}", (Object)artifact);
                continue;
            }
            String id = MojoHelper.getArtifactId(artifact);
            if (verbose) {
                LOG.info("detected artifact {}", (Object)id);
            }
            if ((depMavenProject = (MavenProject)localCache.get(id)) != null) {
                if (verbose) {
                    LOG.info("add dependency [{}] (from cache)", (Object)id);
                }
            } else {
                block19: {
                    try {
                        depMavenProject = this.mavenProjectBuilder.build(artifact, true, projectBuildingRequest).getProject();
                        depMavenProject.getArtifact().setScope(artifact.getScope());
                        if (!depMavenProject.getGroupId().equals(artifact.getGroupId())) {
                            depMavenProject.setGroupId(artifact.getGroupId());
                            depMavenProject.getArtifact().setGroupId(artifact.getGroupId());
                        }
                        if (!depMavenProject.getArtifactId().equals(artifact.getArtifactId())) {
                            depMavenProject.setArtifactId(artifact.getArtifactId());
                            depMavenProject.getArtifact().setArtifactId(artifact.getArtifactId());
                        }
                        if (depMavenProject.getVersion().equals(artifact.getVersion())) break block19;
                        depMavenProject.setVersion(artifact.getVersion());
                        depMavenProject.getArtifact().setVersion(artifact.getVersion());
                    }
                    catch (ProjectBuildingException e) {
                        LOG.warn("Unable to obtain POM for artifact: {}", (Object)artifact, (Object)e);
                        continue;
                    }
                }
                if (verbose) {
                    LOG.info("add dependency [{}]", (Object)id);
                }
                localCache.put(id, depMavenProject);
            }
            result.put(id, depMavenProject);
            excludeArtifacts.remove(artifact.getId());
            includeArtifacts.put(artifact.getId(), artifact);
        }
        if (excludeTransitiveDependencies) {
            for (Map.Entry entry : includeArtifacts.entrySet()) {
                List dependencyTrail = ((Artifact)entry.getValue()).getDependencyTrail();
                boolean remove = false;
                for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
                    if (!excludeArtifacts.containsKey(dependencyTrail.get(i))) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                result.remove(MojoHelper.getArtifactId((Artifact)entry.getValue()));
            }
        }
        if (cache != null) {
            cache.putAll(result);
        }
        return result;
    }
}

