/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.api.ThirdPartyDetails;

public class DefaultThirdPartyDetails
implements ThirdPartyDetails {
    private String[] pomLicenses;
    private String[] thirdPartyLicenses;
    private final MavenProject project;

    public DefaultThirdPartyDetails(MavenProject project) {
        this.project = project;
    }

    public String getGroupId() {
        return this.project.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifact().getArtifactId();
    }

    public String getVersion() {
        return this.project.getArtifact().getVersion();
    }

    public String getType() {
        return this.project.getArtifact().getType();
    }

    public String getClassifier() {
        return this.project.getArtifact().getClassifier();
    }

    public String getScope() {
        return this.project.getArtifact().getScope();
    }

    public boolean hasPomLicenses() {
        return this.pomLicenses != null && this.pomLicenses.length > 0;
    }

    public String[] getLicenses() {
        String[] result = null;
        if (this.hasPomLicenses()) {
            result = this.getPomLicenses();
        } else if (this.hasThirdPartyLicenses()) {
            result = this.getThirdPartyLicenses();
        }
        return result;
    }

    public boolean hasLicenses() {
        return this.hasPomLicenses() || this.hasThirdPartyLicenses();
    }

    public String[] getPomLicenses() {
        return this.pomLicenses;
    }

    public void setPomLicenses(String[] pomLicenses) {
        this.pomLicenses = pomLicenses;
    }

    public String[] getThirdPartyLicenses() {
        return this.thirdPartyLicenses;
    }

    public boolean hasThirdPartyLicenses() {
        return this.thirdPartyLicenses != null && this.thirdPartyLicenses.length > 0;
    }

    public void setThirdPartyLicenses(String[] thirdPartyLicenses) {
        this.thirdPartyLicenses = thirdPartyLicenses;
    }
}

