/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.download.License;
import org.codehaus.mojo.license.download.LicensedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=LicensedArtifactResolver.class, hint="default")
public class LicensedArtifactResolver
extends AbstractLogEnabled {
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Requirement
    private MavenProjectBuilder mavenProjectBuilder;

    public void loadProjectDependencies(ResolvedProjectDependencies artifacts, MavenProjectDependenciesConfigurator configuration, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Map<String, LicensedArtifact> result) {
        ArtifactFilters artifactFilters = configuration.getArtifactFilters();
        boolean excludeTransitiveDependencies = configuration.isExcludeTransitiveDependencies();
        Set<Artifact> depArtifacts = configuration.isIncludeTransitiveDependencies() ? artifacts.getAllDependencies() : artifacts.getDirectDependencies();
        boolean verbose = configuration.isVerbose();
        HashMap<String, Artifact> excludeArtifacts = new HashMap<String, Artifact>();
        HashMap<String, Artifact> includeArtifacts = new HashMap<String, Artifact>();
        Logger log = this.getLogger();
        for (Artifact artifact : depArtifacts) {
            LicensedArtifact depMavenProject;
            excludeArtifacts.put(artifact.getId(), artifact);
            if ("license.properties".equals(artifact.getType())) continue;
            if (!artifactFilters.isIncluded(artifact)) {
                if (!verbose) continue;
                log.debug("Excluding artifact " + artifact);
                continue;
            }
            String id = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
            if (verbose) {
                log.info("detected artifact " + id);
            }
            if ((depMavenProject = result.get(id)) != null) {
                log.debug("Dependency [" + id + "] already present in the result");
            } else {
                LicensedArtifact.Builder laBuilder = LicensedArtifact.builder(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                try {
                    MavenProject project = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository, true);
                    List lics = project.getLicenses();
                    if (lics != null) {
                        for (org.apache.maven.model.License lic : lics) {
                            laBuilder.license(new License(lic.getName(), lic.getUrl(), lic.getDistribution(), lic.getComments()));
                        }
                    }
                }
                catch (ProjectBuildingException e) {
                    laBuilder.errorMessage(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage());
                }
                depMavenProject = laBuilder.build();
                if (verbose) {
                    log.info("add dependency [" + id + "]");
                }
                result.put(id, depMavenProject);
            }
            excludeArtifacts.remove(artifact.getId());
            includeArtifacts.put(artifact.getId(), artifact);
        }
        if (excludeTransitiveDependencies) {
            for (Map.Entry entry : includeArtifacts.entrySet()) {
                List dependencyTrail = ((Artifact)entry.getValue()).getDependencyTrail();
                boolean remove = false;
                for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
                    if (!excludeArtifacts.containsKey(dependencyTrail.get(i))) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                result.remove(entry.getKey());
            }
        }
    }
}

