/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.utils.UrlRequester;

public class ArtifactFilters {
    private final IncludesExcludes gaFilters;
    private final IncludesExcludes scopeFilters;
    private final IncludesExcludes typeFilters;

    public static Builder buidler() {
        return new Builder();
    }

    public static ArtifactFilters of(MavenProjectDependenciesConfigurator config) {
        Builder builder = new Builder();
        builder.includeGa(ArtifactFilters.toGaPattern(config.getIncludedGroups(), true));
        builder.excludeGa(ArtifactFilters.toGaPattern(config.getExcludedGroups(), true));
        builder.includeGa(ArtifactFilters.toGaPattern(config.getIncludedArtifacts(), false));
        builder.excludeGa(ArtifactFilters.toGaPattern(config.getExcludedArtifacts(), false));
        builder.includeScopes(config.getIncludedScopes());
        builder.excludeScopes(config.getExcludedScopes());
        builder.includeTypes(config.getIncludedTypes());
        builder.excludeTypes(config.getExcludedTypes());
        String url = config.getArtifactFiltersUrl();
        if (url != null) {
            try {
                String content = UrlRequester.getFromUrl(url, config.getEncoding());
                if (content != null) {
                    builder.script(url, content);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.build();
    }

    private static String toGaPattern(String rawPattern, boolean isGroup) {
        if (rawPattern == null) {
            return null;
        }
        rawPattern = "[^:]*(" + rawPattern + ")[^:]*";
        if (isGroup) {
            return rawPattern + ":[^:]+";
        }
        return "[^:]+:" + rawPattern;
    }

    public ArtifactFilters(IncludesExcludes scopeFilters, IncludesExcludes typeFilters, IncludesExcludes gaFilters) {
        this.scopeFilters = scopeFilters;
        this.typeFilters = typeFilters;
        this.gaFilters = gaFilters;
    }

    public boolean isIncluded(Artifact artifact) {
        return this.scopeFilters.isIncluded(artifact) && this.typeFilters.isIncluded(artifact) && this.gaFilters.isIncluded(artifact);
    }

    static class TypeFilter
    implements ArtifactFilter {
        private final String type;

        public TypeFilter(String type) {
            this.type = type;
        }

        @Override
        public boolean matches(Artifact artifact) {
            return this.type.equals(artifact.getType());
        }
    }

    static class ScopeFilter
    implements ArtifactFilter {
        private final String scope;

        public ScopeFilter(String scope) {
            this.scope = scope;
        }

        @Override
        public boolean matches(Artifact artifact) {
            return this.scope.equals(artifact.getScope());
        }
    }

    static class IncludesExcludes {
        private final int includesCount;
        private final List<ArtifactFilter> includesExcludes;

        public IncludesExcludes(List<ArtifactFilter> includesExcludes, int includesCount) {
            this.includesExcludes = includesExcludes;
            this.includesCount = includesCount;
        }

        public boolean isIncluded(Artifact artifact) {
            return (this.includesCount == 0 || this.matchesAny(artifact, 0, this.includesCount)) && !this.matchesAny(artifact, this.includesCount, this.includesExcludes.size());
        }

        boolean matchesAny(Artifact artifact, int start, int end) {
            if (start < this.includesExcludes.size()) {
                for (int i = start; i < end; ++i) {
                    if (!this.includesExcludes.get(i).matches(artifact)) continue;
                    return true;
                }
            }
            return false;
        }

        static class Builder {
            private int includesCount = 0;
            private List<ArtifactFilter> includesExcludes = new ArrayList<ArtifactFilter>();

            Builder() {
            }

            public IncludesExcludes build() {
                List<ArtifactFilter> ie = this.includesExcludes;
                this.includesExcludes = null;
                return new IncludesExcludes(ie, this.includesCount);
            }

            public Builder exclude(ArtifactFilter filter) {
                this.includesExcludes.add(filter);
                return this;
            }

            public Builder include(ArtifactFilter filter) {
                this.includesExcludes.add(this.includesCount, filter);
                ++this.includesCount;
                return this;
            }
        }
    }

    static class GaFilter
    implements ArtifactFilter {
        private final Pattern pattern;

        public GaFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(Artifact artifact) {
            return this.pattern.matcher(artifact.getGroupId() + ":" + artifact.getArtifactId()).matches();
        }
    }

    public static class Builder {
        private final IncludesExcludes.Builder gaFilters = new IncludesExcludes.Builder();
        private final IncludesExcludes.Builder scopeFilters = new IncludesExcludes.Builder();
        private final IncludesExcludes.Builder typeFilters = new IncludesExcludes.Builder();

        public ArtifactFilters build() {
            return new ArtifactFilters(this.scopeFilters.build(), this.typeFilters.build(), this.gaFilters.build());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void script(String url, String content) {
            StringTokenizer st = new StringTokenizer(content, "\r\n");
            int i = 1;
            while (st.hasMoreTokens()) {
                String line = st.nextToken().trim();
                if (!line.startsWith("#") && !line.isEmpty()) {
                    String[] items = line.split("\\s+");
                    if (items.length != 3) {
                        throw new IllegalStateException("Expected 3 space separated tokens on line " + i + " in " + url + " found: " + line);
                    }
                    if ("include".equals(items[0])) {
                        if ("gaPattern".equals(items[1])) {
                            this.includeGa(items[2]);
                        } else if ("scope".equals(items[1])) {
                            this.includeScope(items[2]);
                        } else {
                            if (!"type".equals(items[1])) throw new IllegalStateException("Expected \"gaPattern\", \"scope\" or \"type\" after \"" + items[0] + "\" on line " + i + " in " + url + " found: " + line);
                            this.includeType(items[2]);
                        }
                    } else {
                        if (!"exclude".equals(items[0])) throw new IllegalStateException("Expected a line starting with \"include\" or \"exclude\" on line " + i + " in " + url + " found: " + line);
                        if ("gaPattern".equals(items[1])) {
                            this.excludeGa(items[2]);
                        } else if ("scope".equals(items[1])) {
                            this.excludeScope(items[2]);
                        } else {
                            if (!"type".equals(items[1])) throw new IllegalStateException("Expected \"gaPattern\", \"scope\" or \"type\" after \"" + items[0] + "\" on line " + i + " in " + url + " found: " + line);
                            this.excludeType(items[2]);
                        }
                    }
                }
                ++i;
            }
        }

        public Builder excludeGa(String pattern) {
            if (pattern != null) {
                this.gaFilters.exclude(new GaFilter(Pattern.compile(pattern)));
            }
            return this;
        }

        public Builder excludeGas(String ... patterns) {
            if (patterns != null) {
                for (String pattern : patterns) {
                    this.gaFilters.exclude(new GaFilter(Pattern.compile(pattern)));
                }
            }
            return this;
        }

        public Builder excludeScope(String scope) {
            this.scopeFilters.exclude(new ScopeFilter(scope));
            return this;
        }

        public Builder excludeScopes(String ... scopes) {
            if (scopes != null) {
                for (String scope : scopes) {
                    this.scopeFilters.exclude(new ScopeFilter(scope));
                }
            }
            return this;
        }

        public Builder excludeScopes(Collection<String> scopes) {
            if (scopes != null) {
                for (String scope : scopes) {
                    this.scopeFilters.exclude(new ScopeFilter(scope));
                }
            }
            return this;
        }

        public Builder excludeType(String type) {
            this.typeFilters.exclude(new TypeFilter(type));
            return this;
        }

        public Builder excludeTypes(String ... types) {
            if (types != null) {
                for (String type : types) {
                    this.typeFilters.exclude(new TypeFilter(type));
                }
            }
            return this;
        }

        public Builder excludeTypes(Collection<String> types) {
            if (types != null) {
                for (String type : types) {
                    this.typeFilters.exclude(new TypeFilter(type));
                }
            }
            return this;
        }

        public Builder includeGa(String pattern) {
            if (pattern != null) {
                this.gaFilters.include(new GaFilter(Pattern.compile(pattern)));
            }
            return this;
        }

        public Builder includeGas(String ... patterns) {
            if (patterns != null) {
                for (String pattern : patterns) {
                    this.gaFilters.include(new GaFilter(Pattern.compile(pattern)));
                }
            }
            return this;
        }

        public Builder includeScope(String scope) {
            this.scopeFilters.include(new ScopeFilter(scope));
            return this;
        }

        public Builder includeScopes(String ... scopes) {
            if (scopes != null) {
                for (String scope : scopes) {
                    this.scopeFilters.include(new ScopeFilter(scope));
                }
            }
            return this;
        }

        public Builder includeScopes(Collection<String> scopes) {
            if (scopes != null) {
                for (String scope : scopes) {
                    this.scopeFilters.include(new ScopeFilter(scope));
                }
            }
            return this;
        }

        public Builder includeType(String type) {
            this.typeFilters.include(new TypeFilter(type));
            return this;
        }

        public Builder includeTypes(String ... types) {
            if (types != null) {
                for (String type : types) {
                    this.typeFilters.include(new TypeFilter(type));
                }
            }
            return this;
        }

        public Builder includeTypes(Collection<String> types) {
            if (types != null) {
                for (String type : types) {
                    this.typeFilters.include(new TypeFilter(type));
                }
            }
            return this;
        }
    }

    static interface ArtifactFilter {
        public boolean matches(Artifact var1);
    }
}

