/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.mojo.license.Eol;
import org.codehaus.mojo.license.LicenseUrlReplacement;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.download.Cache;
import org.codehaus.mojo.license.download.FileNameEntry;
import org.codehaus.mojo.license.download.LicenseDownloader;
import org.codehaus.mojo.license.download.LicenseMatchers;
import org.codehaus.mojo.license.download.LicenseSummaryWriter;
import org.codehaus.mojo.license.download.PreferredFileNames;
import org.codehaus.mojo.license.download.ProjectLicense;
import org.codehaus.mojo.license.download.ProjectLicenseInfo;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;

public abstract class AbstractDownloadLicensesMojo
extends AbstractMojo
implements MavenProjectDependenciesConfigurator {
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="licensesConfigFile", defaultValue="${project.basedir}/src/license/licenses.xml")
    protected File licensesConfigFile;
    @Parameter(property="licensesOutputDirectory", defaultValue="${project.build.directory}/generated-resources/licenses")
    protected File licensesOutputDirectory;
    @Parameter(property="license.cleanLicensesOutputDirectory", defaultValue="false")
    private boolean cleanLicensesOutputDirectory;
    @Parameter(property="licensesOutputFile", defaultValue="${project.build.directory}/generated-resources/licenses.xml")
    private File licensesOutputFile;
    @Parameter(property="licensesOutputFileEol", defaultValue="AUTODETECT")
    private Eol licensesOutputFileEol;
    @Parameter(property="licensesOutputFileEncoding", defaultValue="${project.build.sourceEncoding}")
    private String licensesOutputFileEncoding;
    @Parameter(property="license.licensesErrorsFile", defaultValue="${project.build.directory}/generated-resources/licenses-errors.xml")
    private File licensesErrorsFile;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes")
    private String includedScopes;
    @Parameter(property="license.excludedTypes")
    private String excludedTypes;
    @Parameter(property="license.includedTypes")
    private String includedTypes;
    @Parameter(property="license.artifactFiltersUrl")
    private String artifactFiltersUrl;
    @Parameter(defaultValue="${settings.offline}")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(property="license.errorRemedy", defaultValue="warn")
    protected ErrorRemedy errorRemedy;
    @Parameter(property="license.forceDownload", defaultValue="false")
    private boolean forceDownload;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    private boolean excludeTransitiveDependencies;
    @Parameter(defaultValue="${settings.proxies}", readonly=true)
    private List<Proxy> proxies;
    @Parameter(property="license.organizeLicensesByDependencies", defaultValue="false")
    protected boolean organizeLicensesByDependencies;
    @Parameter(property="license.sortByGroupIdAndArtifactId", defaultValue="false")
    private boolean sortByGroupIdAndArtifactId;
    @Parameter(property="license.excludedGroups")
    private String excludedGroups;
    @Parameter(property="license.includedGroups")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    private String includedArtifacts;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    protected List<LicenseUrlReplacement> licenseUrlReplacements;
    @Parameter
    protected Map<String, String> licenseUrlFileNames;
    @Parameter
    protected List<LicenseUrlReplacement> licenseUrlFileNameSanitizers;
    @Parameter(property="license.writeVersions", defaultValue="true")
    private boolean writeVersions;
    @Parameter(property="license.connectTimeout", defaultValue="5000")
    private int connectTimeout;
    @Parameter(property="license.socketTimeout", defaultValue="5000")
    private int socketTimeout;
    @Parameter(property="license.connectionRequestTimeout", defaultValue="5000")
    private int connectionRequestTimeout;
    @Component
    private DependenciesTool dependenciesTool;
    private PreferredFileNames preferredFileNames;
    private Cache cache;
    private int downloadErrorCount = 0;

    protected abstract boolean isSkip();

    protected MavenProject getProject() {
        return this.project;
    }

    protected abstract Set<MavenProject> getDependencies();

    protected SortedMap<String, MavenProject> getDependencies(MavenProject project) {
        return this.dependenciesTool.loadProjectDependencies(new ResolvedProjectDependencies(project.getArtifacts(), project.getDependencyArtifacts()), this, this.localRepository, this.remoteRepositories, null);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return;
        }
        this.errorRemedy = AbstractDownloadLicensesMojo.getEffectiveErrorRemedy(this.quiet, this.errorRemedy);
        this.preferredFileNames = PreferredFileNames.build(this.licensesOutputDirectory, this.licenseUrlFileNames, this.getLog());
        this.cache = new Cache(this.licenseUrlFileNames != null && !this.licenseUrlFileNames.isEmpty());
        this.initDirectories();
        if (this.licensesOutputFileEncoding == null) {
            this.licensesOutputFileEncoding = System.getProperty("file.encoding");
            this.getLog().warn((CharSequence)"Using the default system encoding for reading or writing licenses.xml file. This makes your build platform dependent. You should set either project.build.sourceEncoding or licensesOutputFileEncoding");
        }
        Charset charset = Charset.forName(this.licensesOutputFileEncoding);
        LicenseMatchers matchers = LicenseMatchers.load(this.licensesConfigFile);
        Set<MavenProject> dependencies = this.getDependencies();
        ArrayList<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
        try (LicenseDownloader licenseDownloader = new LicenseDownloader(this.findActiveProxy(), this.connectTimeout, this.socketTimeout, this.connectionRequestTimeout);){
            for (MavenProject project : dependencies) {
                Artifact artifact = project.getArtifact();
                this.getLog().debug((CharSequence)("Checking licenses for project " + artifact));
                ProjectLicenseInfo depProject = this.createDependencyProject(project);
                matchers.replaceMatches(depProject);
                depProjectLicenses.add(depProject);
            }
            if (!this.offline) {
                for (ProjectLicenseInfo depProject : depProjectLicenses) {
                    this.downloadLicenses(licenseDownloader, depProject, true);
                }
                this.getLog().debug((CharSequence)"Finished populating cache");
                for (ProjectLicenseInfo depProject : depProjectLicenses) {
                    this.downloadLicenses(licenseDownloader, depProject, false);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.sortByGroupIdAndArtifactId) {
                this.sortByGroupIdAndArtifactId(depProjectLicenses);
            }
            if (this.licensesOutputFileEol == Eol.AUTODETECT) {
                Path autodetectFromFile = this.licensesConfigFile.exists() ? this.licensesConfigFile.toPath() : this.project.getBasedir().toPath().resolve("pom.xml");
                this.licensesOutputFileEol = Eol.autodetect(autodetectFromFile, charset);
            }
            List<ProjectLicenseInfo> depProjectLicensesWithErrors = this.filterErrors(depProjectLicenses);
            LicenseSummaryWriter.writeLicenseSummary(depProjectLicenses, this.licensesOutputFile, charset, this.licensesOutputFileEol, this.writeVersions);
            if (depProjectLicensesWithErrors != null && !depProjectLicensesWithErrors.isEmpty()) {
                LicenseSummaryWriter.writeLicenseSummary(depProjectLicensesWithErrors, this.licensesErrorsFile, charset, this.licensesOutputFileEol, this.writeVersions);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
        }
        switch (this.errorRemedy) {
            case ignore: 
            case failFast: {
                break;
            }
            case warn: {
                this.getLog().warn((CharSequence)("There were " + this.downloadErrorCount + " download errors - check the warnings above"));
                break;
            }
            case xmlOutput: {
                if (this.downloadErrorCount <= 0) break;
                throw new MojoFailureException("There were " + this.downloadErrorCount + " download errors - check " + this.licensesErrorsFile.getAbsolutePath());
            }
            default: {
                throw new IllegalStateException("Unexpected value of " + ErrorRemedy.class.getName() + ": " + (Object)((Object)this.errorRemedy));
            }
        }
    }

    private List<ProjectLicenseInfo> filterErrors(List<ProjectLicenseInfo> depProjectLicenses) {
        ArrayList<ProjectLicenseInfo> result = new ArrayList<ProjectLicenseInfo>();
        Iterator<ProjectLicenseInfo> it = depProjectLicenses.iterator();
        while (it.hasNext()) {
            ProjectLicenseInfo dep = it.next();
            List<String> messages = dep.getDownloaderMessages();
            if (messages == null || messages.isEmpty()) continue;
            it.remove();
            result.add(dep);
        }
        return result;
    }

    private static ErrorRemedy getEffectiveErrorRemedy(boolean quiet, ErrorRemedy errorRemedy) {
        switch (errorRemedy) {
            case warn: {
                return quiet ? ErrorRemedy.ignore : ErrorRemedy.warn;
            }
        }
        return errorRemedy;
    }

    private void sortByGroupIdAndArtifactId(List<ProjectLicenseInfo> depProjectLicenses) {
        Comparator<ProjectLicenseInfo> comparator = new Comparator<ProjectLicenseInfo>(){

            @Override
            public int compare(ProjectLicenseInfo info1, ProjectLicenseInfo info2) {
                return (info1.getGroupId() + "+" + info1.getArtifactId()).compareTo(info2.getGroupId() + "+" + info2.getArtifactId());
            }
        };
        Collections.sort(depProjectLicenses, comparator);
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    public void setExcludedScopes(String excludedScopes) {
        this.excludedScopes = excludedScopes;
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public List<String> getExcludedTypes() {
        return MojoHelper.getParams(this.excludedTypes);
    }

    @Override
    public List<String> getIncludedTypes() {
        return MojoHelper.getParams(this.includedTypes);
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public String getArtifactFiltersUrl() {
        return this.artifactFiltersUrl;
    }

    @Override
    public String getEncoding() {
        return this.licensesOutputFileEncoding;
    }

    @Override
    public boolean isVerbose() {
        return this.getLog().isDebugEnabled();
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            if (this.licensesOutputDirectory.exists()) {
                if (this.cleanLicensesOutputDirectory) {
                    this.getLog().info((CharSequence)("Cleaning licensesOutputDirectory '" + this.licensesOutputDirectory + "'"));
                    FileUtils.cleanDirectory((File)this.licensesOutputDirectory);
                }
            } else {
                FileUtil.createDirectoryIfNecessary(this.licensesOutputDirectory);
            }
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
            FileUtil.createDirectoryIfNecessary(this.licensesErrorsFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    private Proxy findActiveProxy() throws MojoExecutionException {
        for (Proxy proxy : this.proxies) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            return proxy;
        }
        return null;
    }

    private ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (License license : licenses) {
            dependencyProject.addLicense(new ProjectLicense(license));
        }
        return dependencyProject;
    }

    private FileNameEntry getLicenseFileName(ProjectLicenseInfo depProject, String url, String licenseName, String licenseFileName) throws URISyntaxException {
        URI licenseUrl = new URI(url);
        File licenseUrlFile = new File(licenseUrl.getPath());
        if (this.organizeLicensesByDependencies) {
            if (licenseFileName != null && !licenseFileName.isEmpty()) {
                return new FileNameEntry(new File(this.licensesOutputDirectory, new File(licenseFileName).getName()), false, null);
            }
            licenseFileName = String.format("%s.%s%s", depProject.getGroupId(), depProject.getArtifactId(), licenseName != null ? "_" + licenseName : "").replaceAll("\\s+", "_");
        } else {
            FileNameEntry preferredFileNameEntry = this.preferredFileNames.getEntryByUrl(url);
            if (preferredFileNameEntry != null) {
                return preferredFileNameEntry;
            }
            if (licenseFileName != null && !licenseFileName.isEmpty()) {
                return new FileNameEntry(new File(this.licensesOutputDirectory, new File(licenseFileName).getName()), false, null);
            }
            licenseFileName = licenseUrlFile.getName();
            if (licenseName != null) {
                licenseFileName = licenseName + " - " + licenseUrlFile.getName();
            }
            licenseFileName = licenseFileName.replaceAll("\\s+", " ");
        }
        licenseFileName = licenseFileName.toLowerCase(Locale.US).replaceAll("[\\\\/]+", "_");
        licenseFileName = this.sanitize(licenseFileName);
        return new FileNameEntry(new File(this.licensesOutputDirectory, licenseFileName), false, null);
    }

    private String sanitize(String licenseFileName) {
        if (this.licenseUrlFileNameSanitizers != null) {
            for (LicenseUrlReplacement sanitizer : this.licenseUrlFileNameSanitizers) {
                String replacement;
                Pattern regexp = sanitizer.getRegexp();
                String string = replacement = sanitizer.getReplacement() == null ? "" : sanitizer.getReplacement();
                if (regexp == null) continue;
                licenseFileName = regexp.matcher(licenseFileName).replaceAll(replacement);
            }
        }
        return licenseFileName;
    }

    private void downloadLicenses(LicenseDownloader licenseDownloader, ProjectLicenseInfo depProject, boolean matchingUrlsOnly) throws MojoFailureException {
        this.getLog().debug((CharSequence)("Downloading license(s) for project " + depProject));
        List<ProjectLicense> licenses = depProject.getLicenses();
        if (matchingUrlsOnly && (depProject.getLicenses() == null || depProject.getLicenses().isEmpty())) {
            this.handleError(depProject, "No license information available for: " + depProject);
            return;
        }
        int licenseIndex = 0;
        for (ProjectLicense license : licenses) {
            if (matchingUrlsOnly && license.getUrl() == null) {
                this.handleError(depProject, "No URL for license at index " + licenseIndex + " in dependency " + depProject.toString());
            } else if (license.getUrl() != null) {
                String licenseUrl = this.rewriteLicenseUrlIfNecessary(license.getUrl());
                LicenseDownloader.LicenseDownloadResult cachedResult = this.cache.get(licenseUrl);
                try {
                    FileNameEntry fileNameEntry;
                    if (cachedResult != null) {
                        if (cachedResult.isPreferredFileName() == matchingUrlsOnly) {
                            if (this.organizeLicensesByDependencies) {
                                LicenseDownloader.LicenseDownloadResult byDepsResult;
                                fileNameEntry = this.getLicenseFileName(depProject, licenseUrl, license.getName(), license.getFile());
                                File cachedFile = cachedResult.getFile();
                                File byDepsFile = fileNameEntry.getFile();
                                if (cachedResult.isSuccess() && !cachedFile.equals(byDepsFile)) {
                                    Files.copy(cachedFile.toPath(), byDepsFile.toPath(), new CopyOption[0]);
                                    byDepsResult = cachedResult.withFile(byDepsFile);
                                } else {
                                    byDepsResult = cachedResult;
                                }
                                this.handleResult(licenseUrl, byDepsResult, depProject, license);
                            } else {
                                this.handleResult(licenseUrl, cachedResult, depProject, license);
                            }
                        }
                    } else {
                        fileNameEntry = this.getLicenseFileName(depProject, licenseUrl, license.getName(), license.getFile());
                        File licenseOutputFile = fileNameEntry.getFile();
                        if (matchingUrlsOnly == fileNameEntry.isPreferred()) {
                            LicenseDownloader.LicenseDownloadResult result;
                            if (!licenseOutputFile.exists() || this.forceDownload) {
                                File oldFile;
                                String name;
                                result = licenseDownloader.downloadLicense(licenseUrl, fileNameEntry, this.getLog());
                                if (!this.organizeLicensesByDependencies && result.isSuccess() && (name = this.preferredFileNames.getFileNameBySha1(result.getSha1())) != null && !(oldFile = result.getFile()).getName().equals(name)) {
                                    this.getLog().debug((CharSequence)("Found preferred name '" + name + "' by sha1 after downloading '" + licenseUrl + "'; renaming from '" + oldFile.getName() + "'"));
                                    File newFile = new File(this.licensesOutputDirectory, name);
                                    if (newFile.exists()) {
                                        oldFile.delete();
                                    } else {
                                        oldFile.renameTo(newFile);
                                    }
                                    result = result.withFile(newFile);
                                }
                                this.handleResult(licenseUrl, result, depProject, license);
                                this.cache.put(licenseUrl, result);
                            } else if (licenseOutputFile.exists()) {
                                result = LicenseDownloader.LicenseDownloadResult.success(licenseOutputFile, FileUtil.sha1(licenseOutputFile.toPath()), fileNameEntry.isPreferred());
                                this.handleResult(licenseUrl, result, depProject, license);
                                this.cache.put(licenseUrl, result);
                            }
                        }
                    }
                }
                catch (URISyntaxException e) {
                    this.handleError(depProject, "POM for dependency " + depProject.toString() + " has an invalid license URL: " + licenseUrl);
                    this.getLog().debug((Throwable)e);
                }
                catch (FileNotFoundException e) {
                    this.handleError(depProject, "POM for dependency " + depProject.toString() + " has a license URL that returns file not found: " + licenseUrl);
                    this.getLog().debug((Throwable)e);
                }
                catch (IOException e) {
                    this.handleError(depProject, "Unable to retrieve license from URL '" + licenseUrl + "' for dependency '" + depProject.toString() + "': " + e.getMessage());
                    this.getLog().debug((Throwable)e);
                }
            }
            ++licenseIndex;
        }
    }

    private void handleResult(String licenseUrl, LicenseDownloader.LicenseDownloadResult result, ProjectLicenseInfo depProject, ProjectLicense license) throws MojoFailureException {
        if (result.isSuccess()) {
            license.setFile(result.getFile().getName());
        } else {
            this.handleError(depProject, result.getErrorMessage());
        }
    }

    private void handleError(ProjectLicenseInfo depProject, String msg) throws MojoFailureException {
        if (depProject.isApproved()) {
            this.getLog().debug((CharSequence)("Supressing manually approved license issue: " + msg));
        } else {
            switch (this.errorRemedy) {
                case ignore: {
                    break;
                }
                case warn: {
                    this.getLog().warn((CharSequence)msg);
                    break;
                }
                case failFast: {
                    throw new MojoFailureException(msg);
                }
                case xmlOutput: {
                    this.getLog().debug((CharSequence)msg);
                    depProject.addDownloaderMessage(msg);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value of " + ErrorRemedy.class.getName() + ": " + (Object)((Object)this.errorRemedy));
                }
            }
            ++this.downloadErrorCount;
        }
    }

    private String rewriteLicenseUrlIfNecessary(String originalLicenseUrl) {
        String resultUrl = originalLicenseUrl;
        if (this.licenseUrlReplacements != null) {
            for (LicenseUrlReplacement urlReplacement : this.licenseUrlReplacements) {
                String replacement;
                Pattern regexp = urlReplacement.getRegexp();
                String string = replacement = urlReplacement.getReplacement() == null ? "" : urlReplacement.getReplacement();
                if (regexp == null) continue;
                resultUrl = regexp.matcher(resultUrl).replaceAll(replacement);
            }
            if (!resultUrl.equals(originalLicenseUrl)) {
                this.getLog().debug((CharSequence)String.format("Rewrote URL %s => %s", originalLicenseUrl, resultUrl));
            }
        }
        return resultUrl;
    }

    public static enum ErrorRemedy {
        ignore,
        warn,
        failFast,
        xmlOutput;

    }
}

