/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.license.ThirdPartyReportRenderer;
import org.codehaus.mojo.license.api.DefaultThirdPartyDetails;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractThirdPartyReportMojo
extends AbstractMavenReport
implements MavenProjectDependenciesConfigurator {
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes")
    private String includedScopes;
    @Parameter(property="license.excludedGroups")
    private String excludedGroups;
    @Parameter(property="license.includedGroups")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    private String includedArtifacts;
    @Parameter(property="license.includeTransitiveDependencies", defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    private boolean excludeTransitiveDependencies;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    private boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    private File missingFile;
    @Parameter(property="license.overrideFile", defaultValue="src/license/override-THIRD-PARTY.properties")
    private File overrideFile;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    private boolean useRepositoryMissingFiles;
    @Parameter
    private List<String> licenseMerges;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="license.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private Renderer siteRenderer;
    @Component
    private I18N i18n;
    @Component
    private DependenciesTool dependenciesTool;
    @Component
    private ThirdPartyTool thirdPartyTool;

    protected abstract Collection<ThirdPartyDetails> createThirdPartyDetails() throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException, InvalidDependencyVersionException, ArtifactNotFoundException, ArtifactResolutionException, DependenciesToolException;

    protected void executeReport(Locale locale) throws MavenReportException {
        Collection<ThirdPartyDetails> details;
        try {
            details = this.createThirdPartyDetails();
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ThirdPartyToolException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MojoFailureException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (DependenciesToolException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        ThirdPartyReportRenderer renderer = new ThirdPartyReportRenderer(this.getSink(), this.i18n, this.getOutputName(), locale, details);
        renderer.render();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString(this.getOutputName(), locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString(this.getOutputName(), locale, "report.title");
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    Collection<ThirdPartyDetails> createThirdPartyDetails(MavenProject project, boolean loadArtifacts) throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException, DependenciesToolException {
        if (loadArtifacts) {
            this.dependenciesTool.loadProjectArtifacts(this.localRepository, project.getRemoteArtifactRepositories(), project, null);
        }
        DefaultThirdPartyHelper thirdPartyHelper = new DefaultThirdPartyHelper(project, this.encoding, this.verbose, this.dependenciesTool, this.thirdPartyTool, this.localRepository, project.getRemoteArtifactRepositories(), this.getLog());
        SortedMap<String, MavenProject> projectDependencies = thirdPartyHelper.loadDependencies(this);
        LicenseMap licenseMap = thirdPartyHelper.createLicenseMap(projectDependencies);
        SortedSet<MavenProject> dependenciesWithNoLicense = thirdPartyHelper.getProjectsWithNoLicense(licenseMap);
        TreeSet<MavenProject> dependenciesWithPomLicense = new TreeSet<MavenProject>(MojoHelper.newMavenProjectComparator());
        dependenciesWithPomLicense.addAll(projectDependencies.values());
        if (CollectionUtils.isNotEmpty(dependenciesWithNoLicense)) {
            dependenciesWithPomLicense.removeAll(dependenciesWithNoLicense);
            if (this.useMissingFile) {
                thirdPartyHelper.createUnsafeMapping(licenseMap, this.missingFile, this.useRepositoryMissingFiles, dependenciesWithNoLicense, projectDependencies);
            }
        }
        thirdPartyHelper.mergeLicenses(this.licenseMerges, licenseMap);
        this.thirdPartyTool.overrideLicenses(licenseMap, projectDependencies, this.encoding, this.overrideFile);
        ArrayList<ThirdPartyDetails> details = new ArrayList<ThirdPartyDetails>();
        for (Map.Entry<MavenProject, String[]> entry : licenseMap.toDependencyMap().entrySet()) {
            MavenProject dependency = entry.getKey();
            String[] licenses = entry.getValue();
            DefaultThirdPartyDetails detail = new DefaultThirdPartyDetails(dependency);
            details.add(detail);
            if (dependenciesWithPomLicense.contains(dependency)) {
                detail.setPomLicenses(licenses);
                continue;
            }
            if (dependenciesWithNoLicense.contains(dependency)) continue;
            detail.setThirdPartyLicenses(licenses);
        }
        return details;
    }
}

