/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.api.ThirdPartyDetails;

public class DefaultThirdPartyDetails
implements ThirdPartyDetails {
    private String[] pomLicenses;
    private String[] thirdPartyLicenses;
    private final MavenProject project;

    public DefaultThirdPartyDetails(MavenProject project) {
        this.project = project;
    }

    public String getGroupId() {
        return this.project.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.project.getArtifact().getArtifactId();
    }

    public String getVersion() {
        return this.project.getArtifact().getVersion();
    }

    public String getType() {
        return this.project.getArtifact().getType();
    }

    public String getClassifier() {
        return this.project.getArtifact().getClassifier();
    }

    public String getScope() {
        return this.project.getArtifact().getScope();
    }

    public boolean hasPomLicenses() {
        return this.pomLicenses != null && this.pomLicenses.length > 0;
    }

    public String[] getLicenses() {
        String[] result = null;
        if (this.hasPomLicenses()) {
            result = this.getPomLicenses();
        } else if (this.hasThirdPartyLicenses()) {
            result = this.getThirdPartyLicenses();
        }
        return result;
    }

    public boolean hasLicenses() {
        return this.hasPomLicenses() || this.hasThirdPartyLicenses();
    }

    public String[] getPomLicenses() {
        return this.pomLicenses;
    }

    public void setPomLicenses(String[] pomLicenses) {
        this.pomLicenses = pomLicenses;
    }

    public String[] getThirdPartyLicenses() {
        return this.thirdPartyLicenses;
    }

    public boolean hasThirdPartyLicenses() {
        return this.thirdPartyLicenses != null && this.thirdPartyLicenses.length > 0;
    }

    public void setThirdPartyLicenses(String[] thirdPartyLicenses) {
        this.thirdPartyLicenses = thirdPartyLicenses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultThirdPartyDetails that = (DefaultThirdPartyDetails)o;
        return new EqualsBuilder().append((Object)this.getGroupId(), (Object)that.getGroupId()).append((Object)this.getArtifactId(), (Object)that.getArtifactId()).append((Object)this.getVersion(), (Object)that.getVersion()).append((Object)this.getClassifier(), (Object)that.getClassifier()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getGroupId()).append((Object)this.getArtifactId()).append((Object)this.getVersion()).append((Object)this.getClassifier()).toHashCode();
    }
}

